/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.RTPPacketParser;
import net.sf.fmj.media.rtp.util.RTPPacketReceiver;
import net.sf.fmj.media.rtp.util.UDPPacketReceiver;

public class RTPRawReceiver
extends PacketFilter {
    private OverallStats stats = null;
    private boolean recvBufSizeSet = false;
    public DatagramSocket socket;
    private RTPConnector rtpConnector = null;
    private final RTPPacketParser parser = new RTPPacketParser();

    public RTPRawReceiver() {
    }

    public RTPRawReceiver(DatagramSocket datagramSocket, OverallStats overallStats) {
        this.setSource(new UDPPacketReceiver(datagramSocket, 2000));
        this.stats = overallStats;
    }

    public RTPRawReceiver(int n, String string, OverallStats overallStats) throws UnknownHostException, IOException, SocketException {
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(n & 0xFFFFFFFE, string, -1, null, 2000, null);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
        this.stats = overallStats;
    }

    public RTPRawReceiver(RTPConnector rTPConnector, OverallStats overallStats) {
        try {
            this.setSource(new RTPPacketReceiver(rTPConnector.getDataInputStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.rtpConnector = rTPConnector;
        this.stats = overallStats;
    }

    public RTPRawReceiver(RTPPushDataSource rTPPushDataSource, OverallStats overallStats) {
        this.setSource(new RTPPacketReceiver(rTPPushDataSource));
        this.stats = overallStats;
    }

    public RTPRawReceiver(SessionAddress sessionAddress, SessionAddress sessionAddress2, OverallStats overallStats, DatagramSocket datagramSocket) throws UnknownHostException, IOException, SocketException {
        this.stats = overallStats;
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(sessionAddress.getDataPort(), sessionAddress.getDataHostAddress(), sessionAddress2.getDataPort(), sessionAddress2.getDataHostAddress(), 2000, datagramSocket);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public String filtername() {
        return "RTP Raw Packet Receiver";
    }

    public int getRecvBufSize() {
        try {
            Class<?> clazz = this.socket.getClass();
            Method method = clazz.getMethod("getReceiveBufferSize", new Class[0]);
            Integer n = (Integer)method.invoke((Object)this.socket, new Object[0]);
            return n;
        }
        catch (Exception exception) {
            if (this.rtpConnector != null) {
                return this.rtpConnector.getReceiveBufferSize();
            }
            return -1;
        }
    }

    public Packet handlePacket(Packet packet) {
        RTPPacket rTPPacket;
        this.stats.update(0, 1);
        this.stats.update(1, packet.length);
        try {
            rTPPacket = this.parser.parse(packet);
        }
        catch (BadFormatException badFormatException) {
            this.stats.update(2, 1);
            return null;
        }
        if (!this.recvBufSizeSet) {
            this.recvBufSizeSet = true;
            switch (rTPPacket.payloadType) {
                case 14: 
                case 26: 
                case 34: 
                case 42: {
                    this.setRecvBufSize(64000);
                    break;
                }
                case 31: {
                    this.setRecvBufSize(128000);
                    break;
                }
                case 32: {
                    this.setRecvBufSize(128000);
                    break;
                }
                default: {
                    if (rTPPacket.payloadType < 96 || rTPPacket.payloadType > 127) break;
                    this.setRecvBufSize(64000);
                }
            }
        }
        return rTPPacket;
    }

    public Packet handlePacket(Packet packet, int n) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress, boolean bl) {
        return null;
    }

    public void setRecvBufSize(int n) {
        try {
            if (this.socket == null && this.rtpConnector != null) {
                this.rtpConnector.setReceiveBufferSize(n);
            }
        }
        catch (Exception exception) {
            Log.comment("Cannot set receive buffer size: " + exception);
        }
    }
}

