/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.gst.media.content.unknown;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ClockStoppedException;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import org.gstreamer.Bus;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.MainLoop;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.swing.GstVideoComponent;

public class Handler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private PlayBin playbin;
    private GstVideoComponent videoComponent;
    private static boolean gstInitialized;

    private static URI parseURI(String string) {
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() == null) {
                throw new URISyntaxException(string, "Invalid URI scheme");
            }
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            File file = new File(string);
            if (!file.exists()) {
                throw new IllegalArgumentException("Invalid URI/file " + string, uRISyntaxException);
            }
            return file.toURI();
        }
    }

    private static void initGstreamer() {
        if (gstInitialized) {
            return;
        }
        logger.info("Initializing gstreamer");
        try {
            Gst.init((String)"FMJ GStreamer Handler", (String[])new String[0]);
            Thread thread = new Thread("GST MainLoop Thread"){

                public void run() {
                    new MainLoop().run();
                }
            };
            thread.setDaemon(true);
            thread.start();
            gstInitialized = true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Unable to initialize gstreamer: " + throwable, throwable);
        }
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        Serializable serializable;
        String string;
        Serializable serializable2 = this.getSource().getLocator();
        if (serializable2.getProtocol().equals("file") && (string = URLUtils.createAbsoluteFileUrl(serializable2.toExternalForm())) != null) {
            serializable = new MediaLocator(string);
            if (!serializable2.toExternalForm().equals(((MediaLocator)serializable).toExternalForm())) {
                logger.warning("Changing file URL to absolute, from " + serializable2.toExternalForm() + " to " + serializable);
                serializable2 = serializable;
            }
        }
        string = serializable2.toExternalForm();
        serializable = Handler.parseURI(string);
        this.playbin = new PlayBin(((URI)serializable).toString());
        this.playbin.setURI((URI)serializable);
        this.videoComponent = new GstVideoComponent();
        this.playbin.getBus().connect(new Bus.EOS(){

            public void eosMessage(GstObject gstObject) {
                logger.info("GST eosMessage");
                Thread thread = new Thread("GST EOS Thread"){

                    public void run() {
                        Handler.this.playbin.stop();
                        logger.info("GST eosMessage, posting EOM");
                        try {
                            Handler.this.endOfMedia();
                        }
                        catch (ClockStoppedException clockStoppedException) {
                            logger.log(Level.WARNING, "" + clockStoppedException, clockStoppedException);
                        }
                        logger.info("GST eosMessage, done");
                    }
                };
                Handler.this.getThreadQueue().addThread(thread);
            }
        });
        this.playbin.setVideoSink(this.videoComponent.getElement());
        this.videoComponent.setPreferredSize(new Dimension(640, 480));
        return true;
    }

    public void doPlayerSetMediaTime(Time time) {
        logger.info("Handler.doPlayerSetMediaTime " + time.getNanoseconds());
        this.playbin.setPosition(new org.gstreamer.Time(time.getNanoseconds()));
    }

    public float doPlayerSetRate(float f) {
        logger.fine("Handler.doPlayerSetRate " + f);
        return f;
    }

    public boolean doPlayerStop() {
        logger.fine("Handler.doPlayerStop ");
        this.playbin.stop();
        return true;
    }

    public boolean doPlayerSyncStart(Time time) {
        logger.info("Handler.doPlayerSyncStart" + time);
        if (!this.playbin.isPlaying()) {
            this.playbin.play();
        }
        return true;
    }

    public Component getControlPanelComponent() {
        Component component = super.getControlPanelComponent();
        if (component == null) {
            component = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(component);
        }
        return component;
    }

    public synchronized Time getMediaTime() {
        if (this.getState() < 300) {
            return super.getMediaTime();
        }
        return new Time(this.playbin.getPosition().longValue());
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        long l = this.playbin.getDuration().longValue();
        if (l <= 0L) {
            return DURATION_UNKNOWN;
        }
        return new Time(l);
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        return this.videoComponent;
    }

    public void setSource(DataSource dataSource) throws IncompatibleSourceException {
        logger.fine("DataSource: " + dataSource);
        Handler.initGstreamer();
        if (!gstInitialized) {
            throw new IncompatibleSourceException("Unable to initialize gstreamer");
        }
        if (dataSource.getLocator() == null) {
            throw new IncompatibleSourceException("null source locator");
        }
        super.setSource(dataSource);
    }
}

