/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.nio.ByteBuffer;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.NIOBlockCipher;
import org.jitsi.util.JNIUtils;

public class OpenSSLBlockCipher
implements NIOBlockCipher {
    public static final int AES_128_CTR = 1;
    public static final int AES_128_ECB = 2;
    private static long EVP_aes_128_ctr;
    private static long EVP_aes_128_ecb;
    private static boolean loadLibrary;
    private final String algorithmName;
    private final int blockSize;
    private long ctx;
    private Boolean forEncryption;
    private byte[] key;
    private final long type;

    private static native long EVP_aes_128_ecb();

    private static native int EVP_CIPHER_block_size(long var0);

    private static native boolean EVP_CIPHER_CTX_cleanup(long var0);

    private static native long EVP_CIPHER_CTX_create();

    private static native void EVP_CIPHER_CTX_destroy(long var0);

    private static native boolean EVP_CIPHER_CTX_set_padding(long var0, boolean var2);

    private static native int EVP_CipherFinal_ex(long var0, byte[] var2, int var3, int var4);

    private static native boolean EVP_CipherInit_ex(long var0, long var2, long var4, byte[] var6, byte[] var7, int var8);

    private static native int EVP_CipherUpdate(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7);

    private static native int EVP_CipherUpdate(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    private static native long EVP_get_cipherbyname(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSLBlockCipher(int algorithm) {
        switch (algorithm) {
            case 1: 
            case 2: {
                this.algorithmName = "AES";
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm " + algorithm);
            }
        }
        Class<OpenSSLBlockCipher> clazz = OpenSSLBlockCipher.class;
        synchronized (OpenSSLBlockCipher.class) {
            long type;
            if (loadLibrary) {
                try {
                    JNIUtils.loadLibrary("jnopenssl", OpenSSLBlockCipher.class.getClassLoader());
                    EVP_aes_128_ctr = OpenSSLBlockCipher.EVP_get_cipherbyname("AES-128-CTR");
                    EVP_aes_128_ecb = OpenSSLBlockCipher.EVP_aes_128_ecb();
                }
                finally {
                    loadLibrary = false;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            switch (algorithm) {
                case 1: {
                    long EVP_aes_128_ctr = OpenSSLBlockCipher.EVP_aes_128_ctr;
                    if (EVP_aes_128_ctr == 0L) {
                        throw new IllegalStateException("EVP_aes_128_ctr");
                    }
                    type = EVP_aes_128_ctr;
                    break;
                }
                case 2: {
                    long EVP_aes_128_ecb = OpenSSLBlockCipher.EVP_aes_128_ecb;
                    if (EVP_aes_128_ecb == 0L) {
                        throw new IllegalStateException("EVP_aes_128_ecb");
                    }
                    type = EVP_aes_128_ecb;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("algorithm " + algorithm);
                }
            }
            this.type = type;
            long ctx = OpenSSLBlockCipher.EVP_CIPHER_CTX_create();
            if (ctx == 0L) {
                throw new RuntimeException("EVP_CIPHER_CTX_create");
            }
            boolean ok = false;
            this.ctx = ctx;
            try {
                this.reset();
                int blockSize = OpenSSLBlockCipher.EVP_CIPHER_block_size(type);
                if (algorithm == 1 && blockSize == 1) {
                    blockSize = 16;
                }
                this.blockSize = blockSize;
                ok = true;
            }
            finally {
                if (!ok) {
                    if (this.ctx == ctx) {
                        this.ctx = 0L;
                    }
                    OpenSSLBlockCipher.EVP_CIPHER_CTX_destroy(ctx);
                }
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            long ctx = this.ctx;
            if (ctx != 0L) {
                this.ctx = 0L;
                OpenSSLBlockCipher.EVP_CIPHER_CTX_destroy(ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        byte[] key = params instanceof KeyParameter ? ((KeyParameter)params).getKey() : null;
        this.forEncryption = forEncryption;
        this.key = key;
        this.reset();
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        int blockSize = this.getBlockSize();
        int i = OpenSSLBlockCipher.EVP_CipherUpdate(ctx, out, outOff, blockSize, in, inOff, blockSize);
        if (i < 0) {
            throw new RuntimeException("EVP_CipherUpdate");
        }
        return i;
    }

    @Override
    public int processBlock(ByteBuffer in, int inOff, ByteBuffer out, int outOff) throws DataLengthException, IllegalStateException {
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        int blockSize = this.getBlockSize();
        int i = OpenSSLBlockCipher.EVP_CipherUpdate(ctx, out, outOff, blockSize, in, inOff, blockSize);
        if (i < 0) {
            throw new RuntimeException("EVP_CipherUpdate");
        }
        return i;
    }

    public void reset() {
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        OpenSSLBlockCipher.EVP_CIPHER_CTX_cleanup(ctx);
        Boolean forEncryption = this.forEncryption;
        if (!OpenSSLBlockCipher.EVP_CipherInit_ex(ctx, this.type, 0L, this.key, null, forEncryption == null ? -1 : (forEncryption != false ? 1 : 0))) {
            throw new RuntimeException("EVP_CipherInit_ex(" + this.getAlgorithmName() + ")");
        }
        OpenSSLBlockCipher.EVP_CIPHER_CTX_set_padding(ctx, false);
    }

    static {
        loadLibrary = true;
    }
}

