/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlInput;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlRegion;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlState;

public class RemoteRateControl {
    private static final int kDefaultRttMs = 200;
    private float avgChangePeriod;
    private float avgMaxBitRate;
    private float beta;
    private RateControlState cameFromState;
    private long currentBitRate;
    private final RateControlInput currentInput = new RateControlInput(BandwidthUsage.kBwNormal, 0L, 0.0);
    private boolean initializedBitRate;
    private long lastBitRateChange;
    private long lastChangeMs;
    private long maxConfiguredBitRate;
    private long maxHoldRate;
    private long minConfiguredBitRate;
    private RateControlRegion rateControlRegion;
    private RateControlState rateControlState;
    private long rtt;
    private long timeFirstIncomingEstimate;
    private boolean updated;
    private float varMaxBitRate;

    public RemoteRateControl(long minBitrateBps) {
        this.reset(minBitrateBps, RateControlState.kRcDecrease);
    }

    private long changeBitRate(long currentBitRate, long incomingBitRate, double delayFactor, long nowMs) {
        if (!this.updated) {
            return this.currentBitRate;
        }
        this.updated = false;
        this.updateChangePeriod(nowMs);
        this.changeState(this.currentInput, nowMs);
        float incomingBitRateKbps = (float)incomingBitRate / 1000.0f;
        float stdMaxBitRate = (float)Math.sqrt(this.varMaxBitRate * this.avgMaxBitRate);
        boolean recovery = false;
        switch (this.rateControlState) {
            case kRcHold: {
                this.maxHoldRate = Math.max(this.maxHoldRate, incomingBitRate);
                break;
            }
            case kRcIncrease: {
                if (this.avgMaxBitRate >= 0.0f) {
                    if (incomingBitRateKbps > this.avgMaxBitRate + 3.0f * stdMaxBitRate) {
                        this.changeRegion(RateControlRegion.kRcMaxUnknown);
                        this.avgMaxBitRate = -1.0f;
                    } else if (incomingBitRateKbps > this.avgMaxBitRate + 2.5f * stdMaxBitRate) {
                        this.changeRegion(RateControlRegion.kRcAboveMax);
                    }
                }
                long responseTime = (long)(this.avgChangePeriod + 0.5f) + this.rtt + 300L;
                double alpha = this.getRateIncreaseFactor(nowMs, this.lastBitRateChange, responseTime, delayFactor);
                currentBitRate = (long)((double)currentBitRate * alpha) + 1000L;
                if (this.maxHoldRate > 0L && this.beta * (float)this.maxHoldRate > (float)currentBitRate) {
                    currentBitRate = (long)(this.beta * (float)this.maxHoldRate);
                    this.avgMaxBitRate = this.beta * (float)this.maxHoldRate / 1000.0f;
                    this.changeRegion(RateControlRegion.kRcNearMax);
                    recovery = true;
                }
                this.maxHoldRate = 0L;
                this.lastBitRateChange = nowMs;
                break;
            }
            case kRcDecrease: {
                if (incomingBitRate < this.minConfiguredBitRate) {
                    currentBitRate = this.minConfiguredBitRate;
                } else {
                    currentBitRate = (long)((double)(this.beta * (float)incomingBitRate) + 0.5);
                    if (currentBitRate > this.currentBitRate) {
                        if (this.rateControlRegion != RateControlRegion.kRcMaxUnknown) {
                            currentBitRate = (long)(this.beta * this.avgMaxBitRate * 1000.0f + 0.5f);
                        }
                        currentBitRate = Math.min(currentBitRate, this.currentBitRate);
                    }
                    this.changeRegion(RateControlRegion.kRcNearMax);
                    if (incomingBitRateKbps < this.avgMaxBitRate - 3.0f * stdMaxBitRate) {
                        this.avgMaxBitRate = -1.0f;
                    }
                    this.updateMaxBitRateEstimate(incomingBitRateKbps);
                }
                this.changeState(RateControlState.kRcHold);
                this.lastBitRateChange = nowMs;
                break;
            }
            default: {
                throw new IllegalStateException("rateControlState");
            }
        }
        if (!recovery && (incomingBitRate > 100000L || currentBitRate > 150000L) && (double)currentBitRate > 1.5 * (double)incomingBitRate) {
            currentBitRate = this.currentBitRate;
            this.lastBitRateChange = nowMs;
        }
        return currentBitRate;
    }

    private void changeRegion(RateControlRegion region) {
        this.rateControlRegion = region;
        switch (this.rateControlRegion) {
            case kRcAboveMax: 
            case kRcMaxUnknown: {
                this.beta = 0.9f;
                break;
            }
            case kRcNearMax: {
                this.beta = 0.95f;
                break;
            }
            default: {
                throw new IllegalStateException("rateControlRegion");
            }
        }
    }

    private void changeState(RateControlInput input, long nowMs) {
        switch (this.currentInput.bwState) {
            case kBwNormal: {
                if (this.rateControlState != RateControlState.kRcHold) break;
                this.lastBitRateChange = nowMs;
                this.changeState(RateControlState.kRcIncrease);
                break;
            }
            case kBwOverusing: {
                if (this.rateControlState == RateControlState.kRcDecrease) break;
                this.changeState(RateControlState.kRcDecrease);
                break;
            }
            case kBwUnderusing: {
                this.changeState(RateControlState.kRcHold);
                break;
            }
            default: {
                throw new IllegalStateException("currentInput.bwState");
            }
        }
    }

    private void changeState(RateControlState newState) {
        this.cameFromState = this.rateControlState;
        this.rateControlState = newState;
    }

    public long getLatestEstimate() {
        return this.currentBitRate;
    }

    private double getRateIncreaseFactor(long nowMs, long lastMs, long reactionTimeMs, double noiseVar) {
        double B = 0.0407;
        double b = 0.0025;
        double d = 0.85;
        double c1 = -6.152433425160698;
        double c2 = 800.0;
        double alpha = 1.005 + B / (1.0 + Math.exp(b * (d * (double)reactionTimeMs - (c1 * noiseVar + c2))));
        if (alpha < 1.005) {
            alpha = 1.005;
        } else if (alpha > 1.3) {
            alpha = 1.3;
        }
        if (lastMs > -1L) {
            alpha = Math.pow(alpha, (double)(nowMs - lastMs) / 1000.0);
        }
        if (this.rateControlRegion == RateControlRegion.kRcNearMax) {
            alpha -= (alpha - 1.0) / 2.0;
        } else if (this.rateControlRegion == RateControlRegion.kRcMaxUnknown) {
            alpha += (alpha - 1.0) * 2.0;
        }
        return alpha;
    }

    public boolean isTimeToReduceFurther(long timeNow, long incomingBitrate) {
        long bitrateReductionInterval = Math.max(Math.min(this.rtt, 200L), 10L);
        if (timeNow - this.lastBitRateChange >= bitrateReductionInterval) {
            return true;
        }
        if (this.isValidEstimate()) {
            long threshold = (long)(1.05 * (double)incomingBitrate);
            long bitrateDifference = this.getLatestEstimate() - incomingBitrate;
            return bitrateDifference > threshold;
        }
        return false;
    }

    public boolean isValidEstimate() {
        return this.initializedBitRate;
    }

    public void reset() {
        this.reset(this.minConfiguredBitRate, RateControlState.kRcHold);
    }

    private void reset(long minBitrateBps, RateControlState cameFromState) {
        this.minConfiguredBitRate = minBitrateBps;
        this.currentBitRate = this.maxConfiguredBitRate = 30000000L;
        this.maxHoldRate = 0L;
        this.avgMaxBitRate = -1.0f;
        this.varMaxBitRate = 0.4f;
        this.rateControlState = RateControlState.kRcHold;
        this.cameFromState = cameFromState;
        this.rateControlRegion = RateControlRegion.kRcMaxUnknown;
        this.lastBitRateChange = -1L;
        this.currentInput.bwState = BandwidthUsage.kBwNormal;
        this.currentInput.incomingBitRate = 0L;
        this.currentInput.noiseVar = 1.0;
        this.updated = false;
        this.timeFirstIncomingEstimate = -1L;
        this.initializedBitRate = false;
        this.avgChangePeriod = 1000.0f;
        this.lastChangeMs = -1L;
        this.beta = 0.9f;
        this.rtt = 200L;
    }

    public void setRtt(long rtt) {
        this.rtt = rtt;
    }

    public RateControlRegion update(RateControlInput input, long nowMs) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (!this.initializedBitRate) {
            if (this.timeFirstIncomingEstimate < 0L) {
                if (input.incomingBitRate > 0L) {
                    this.timeFirstIncomingEstimate = nowMs;
                }
            } else if (nowMs - this.timeFirstIncomingEstimate > 500L && input.incomingBitRate > 0L) {
                this.currentBitRate = input.incomingBitRate;
                this.initializedBitRate = true;
            }
        }
        if (this.updated && this.currentInput.bwState == BandwidthUsage.kBwOverusing) {
            this.currentInput.noiseVar = input.noiseVar;
            this.currentInput.incomingBitRate = input.incomingBitRate;
            return this.rateControlRegion;
        }
        this.updated = true;
        this.currentInput.copy(input);
        return this.rateControlRegion;
    }

    public long updateBandwidthEstimate(long nowMs) {
        this.currentBitRate = this.changeBitRate(this.currentBitRate, this.currentInput.incomingBitRate, this.currentInput.noiseVar, nowMs);
        return this.currentBitRate;
    }

    private void updateChangePeriod(long nowMs) {
        long changePeriod = 0L;
        if (this.lastChangeMs > -1L) {
            changePeriod = nowMs - this.lastChangeMs;
        }
        this.lastChangeMs = nowMs;
        this.avgChangePeriod = 0.9f * this.avgChangePeriod + 0.1f * (float)changePeriod;
    }

    private void updateMaxBitRateEstimate(float incomingBitRateKbps) {
        float alpha = 0.05f;
        this.avgMaxBitRate = this.avgMaxBitRate == -1.0f ? incomingBitRateKbps : (1.0f - alpha) * this.avgMaxBitRate + alpha * incomingBitRateKbps;
        float norm = Math.max(this.avgMaxBitRate, 1.0f);
        this.varMaxBitRate = (1.0f - alpha) * this.varMaxBitRate + alpha * (this.avgMaxBitRate - incomingBitRateKbps) * (this.avgMaxBitRate - incomingBitRateKbps) / norm;
        if (this.varMaxBitRate < 0.4f) {
            this.varMaxBitRate = 0.4f;
        }
        if (this.varMaxBitRate > 2.5f) {
            this.varMaxBitRate = 2.5f;
        }
    }
}

