/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.adapters.ElementConsumer;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.SubXMLInputStream;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.BufferedXMLInputStream;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.ElementEvent;
import weblogic.xml.stream.events.Name;

public class BufferedXMLInputStreamImpl
extends XMLInputStreamBase
implements BufferedXMLInputStream,
ElementConsumer {
    protected List readElements;
    protected XMLInputStream parent;
    protected boolean markSet;
    protected int mark;
    protected int position;
    protected XMLEvent currentElement;

    protected BufferedXMLInputStreamImpl(XMLInputStream xMLInputStream) {
        this.init(xMLInputStream);
    }

    protected void init(XMLInputStream xMLInputStream) {
        this.parent = xMLInputStream;
        this.readElements = new ArrayList();
        this.open = true;
        this.mark = 0;
        this.position = 0;
        this.markSet = false;
        this.elementQ = new CircularQueue(8);
    }

    public void initChild(XMLInputStreamBase xMLInputStreamBase) {
        int n = this.position;
        while (n < this.readElements.size()) {
            ElementEvent elementEvent = (ElementEvent)this.readElements.get(n);
            xMLInputStreamBase.add(elementEvent.clone());
            ++n;
        }
        int n2 = this.elementQ.size();
        int n3 = 0;
        while (n3 < n2) {
            ElementEvent elementEvent = (ElementEvent)this.elementQ.remove();
            this.elementQ.add(elementEvent);
            xMLInputStreamBase.add(elementEvent.clone());
            ++n3;
        }
    }

    public boolean add(Object object) {
        if (this.open && object != null) {
            if (this.markSet) {
                this.readElements.add(object);
            } else {
                this.elementQ.add(object);
            }
            this.callbackChildren(object);
            return true;
        }
        return false;
    }

    public void close() throws XMLStreamException {
        this.readElements = null;
        this.open = false;
        this.markSet = false;
        this.mark = 0;
        this.position = 0;
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        if (this.checkBufferSize()) {
            return true;
        }
        if (!this.elementQ.isEmpty()) {
            return true;
        }
        return this.parent.hasNext();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.checkBufferSize()) {
            return (XMLEvent)this.readElements.get(this.position);
        }
        if (!this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        return this.parent.peek();
    }

    protected XMLEvent get() throws XMLStreamException {
        XMLEvent xMLEvent;
        if (this.checkBufferSize()) {
            xMLEvent = (XMLEvent)this.readElements.get(this.position);
            ++this.position;
        } else {
            xMLEvent = super.get();
        }
        return xMLEvent;
    }

    public boolean needsMore() {
        if (this.checkBufferSize()) {
            return false;
        }
        return this.elementQ.isEmpty();
    }

    public boolean checkBufferSize() {
        return this.position < this.readElements.size();
    }

    public boolean parseSome() throws XMLStreamException {
        XMLEvent xMLEvent = this.parent.next();
        return this.add(xMLEvent);
    }

    public void mark() throws XMLStreamException {
        int n = this.mark;
        while (n < this.position) {
            this.readElements.remove(n);
            ++n;
        }
        this.markSet = true;
        this.mark = this.position;
        int n2 = this.elementQ.size();
        int n3 = 0;
        while (n3 < n2) {
            ElementEvent elementEvent = (ElementEvent)this.elementQ.remove();
            this.readElements.add(elementEvent);
            ++n3;
        }
    }

    public void reset() throws XMLStreamException {
        if (!this.markSet) {
            throw new XMLStreamException("Attempt to reset the stream without setting the mark");
        }
        this.markSet = false;
        this.position = this.mark;
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return new SubXMLInputStream(this);
    }

    public static void testRelease(String string) throws Exception {
        System.out.println("Buffering Stream");
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(string));
        BufferedXMLInputStreamImpl bufferedXMLInputStreamImpl = new BufferedXMLInputStreamImpl(xMLInputStreamBase);
        bufferedXMLInputStreamImpl.mark();
        while (bufferedXMLInputStreamImpl.hasNext()) {
            bufferedXMLInputStreamImpl.next();
        }
        bufferedXMLInputStreamImpl.reset();
        System.out.println("Getting Sub Streams");
        while (bufferedXMLInputStreamImpl.skip(2)) {
            XMLInputStream xMLInputStream = bufferedXMLInputStreamImpl.getSubStream();
            XMLEvent xMLEvent = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
            System.out.println("GETTING SUBSTREAMS");
            while (xMLInputStream.hasNext()) {
                System.out.println("SS:[ " + xMLInputStream.next() + " ]");
            }
            xMLInputStream.close();
        }
    }

    public static void testBufferBuffer(String string) throws Exception {
        System.out.println("-----------------------------------Buffer of Buffer ----------------");
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new File(string));
        BufferedXMLInputStream bufferedXMLInputStream = xMLInputStreamFactory.newBufferedInputStream(xMLInputStream);
        bufferedXMLInputStream.mark();
        BufferedXMLInputStream bufferedXMLInputStream2 = xMLInputStreamFactory.newBufferedInputStream((XMLInputStream)bufferedXMLInputStream);
        while (bufferedXMLInputStream2.hasNext()) {
            System.out.println(bufferedXMLInputStream2.next());
        }
        System.out.println("-----------------------------------Rewound first Buffer ----------------");
        bufferedXMLInputStream.reset();
        while (bufferedXMLInputStream.hasNext()) {
            System.out.println(bufferedXMLInputStream.next());
        }
    }

    public static void testRewind(String string) throws Exception {
        System.out.println("-------------- testing rewind ----------");
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new File(string));
        BufferedXMLInputStream bufferedXMLInputStream = xMLInputStreamFactory.newBufferedInputStream(xMLInputStream);
        bufferedXMLInputStream.mark();
        while (bufferedXMLInputStream.hasNext()) {
            System.out.println(bufferedXMLInputStream.next());
        }
        bufferedXMLInputStream.reset();
        System.out.println("-------------- rewinding stream ----------");
        while (bufferedXMLInputStream.hasNext()) {
            System.out.println(bufferedXMLInputStream.next());
        }
    }

    public static void testSubStream(String string) throws Exception {
        System.out.println("-------------- testing substream ----------");
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new File(string));
        BufferedXMLInputStream bufferedXMLInputStream = xMLInputStreamFactory.newBufferedInputStream(xMLInputStream);
        XMLInputStream xMLInputStream2 = bufferedXMLInputStream.getSubStream();
        while (xMLInputStream2.hasNext()) {
            System.out.println("CHILD:" + xMLInputStream2.next());
        }
        System.out.println("-------------- iterating over marked stream ----------");
        bufferedXMLInputStream.mark();
        while (bufferedXMLInputStream.hasNext()) {
            System.out.println("PARENT:" + bufferedXMLInputStream.next());
        }
        bufferedXMLInputStream.reset();
        System.out.println("-------------- rewinding stream ----------");
        while (bufferedXMLInputStream.hasNext()) {
            System.out.println("REWOUND:" + bufferedXMLInputStream.next());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLEvent xMLEvent;
        XMLInputStream xMLInputStream;
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        BufferedXMLInputStreamImpl bufferedXMLInputStreamImpl = new BufferedXMLInputStreamImpl(xMLInputStreamBase);
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING STARTELEMENTS");
        while (bufferedXMLInputStreamImpl.skip(2)) {
            xMLInputStream = bufferedXMLInputStreamImpl.getSubStream();
            xMLEvent = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
            System.out.println("GETTING SUBSTREAMS");
            while (xMLInputStream.hasNext()) {
                System.out.println("SS:[ " + xMLInputStream.next() + " ]");
            }
            xMLInputStream.close();
        }
        bufferedXMLInputStreamImpl.reset();
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING STARTELEMENTS");
        while (bufferedXMLInputStreamImpl.skip(2)) {
            xMLInputStream = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLInputStream.getTypeAsString() + " [");
            System.out.print(xMLInputStream);
            System.out.println("]");
        }
        bufferedXMLInputStreamImpl.reset();
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING ENDELEMENTS");
        while (bufferedXMLInputStreamImpl.skip(4)) {
            xMLInputStream = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLInputStream.getTypeAsString() + " [");
            System.out.print(xMLInputStream);
            System.out.println("]");
        }
        bufferedXMLInputStreamImpl.reset();
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING STARTELEMENTS that are apple:a ");
        while (bufferedXMLInputStreamImpl.skip((XMLName)new Name("apple", "a"), 2)) {
            xMLInputStream = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLInputStream.getTypeAsString() + " [");
            System.out.print(xMLInputStream);
            System.out.println("]");
        }
        bufferedXMLInputStreamImpl.reset();
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING STARTELEMENTS that are apple ");
        while (bufferedXMLInputStreamImpl.skip((XMLName)new Name("apple", null), 2)) {
            xMLInputStream = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLInputStream.getTypeAsString() + " [");
            System.out.print(xMLInputStream);
            System.out.println("]");
        }
        bufferedXMLInputStreamImpl.reset();
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING B ELEMENTS ");
        while (bufferedXMLInputStreamImpl.skip((XMLName)new Name("B"))) {
            xMLInputStream = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLInputStream.getTypeAsString() + " [");
            System.out.print(xMLInputStream);
            System.out.println("]");
        }
        bufferedXMLInputStreamImpl.reset();
        bufferedXMLInputStreamImpl.mark();
        System.out.println("SELECTING STARTELEMENTS");
        while (bufferedXMLInputStreamImpl.skip(2)) {
            xMLInputStream = bufferedXMLInputStreamImpl.getSubStream();
            xMLEvent = bufferedXMLInputStreamImpl.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
            System.out.println("GETTING SUBSTREAMS");
            while (xMLInputStream.hasNext()) {
                System.out.println("SS:[ " + xMLInputStream.next() + " ]");
            }
            xMLInputStream.close();
        }
        BufferedXMLInputStreamImpl.testRelease(stringArray[0]);
        BufferedXMLInputStreamImpl.testBufferBuffer(stringArray[0]);
        BufferedXMLInputStreamImpl.testRewind(stringArray[0]);
        BufferedXMLInputStreamImpl.testSubStream(stringArray[0]);
    }
}

