/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PatternSet
extends DataType
implements Cloneable {
    private Vector includeList;
    private Vector excludeList;
    private Vector includesFileList;
    private Vector excludesFileList;

    public void setRefid(Reference reference) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public void addConfiguredPatternset(PatternSet patternSet) {
        int n;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        String[] stringArray = patternSet.getIncludePatterns(this.getProject());
        String[] stringArray2 = patternSet.getExcludePatterns(this.getProject());
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                this.createInclude().setName(stringArray[n]);
                ++n;
            }
        }
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                this.createExclude().setName(stringArray2[n]);
                ++n;
            }
        }
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includesFileList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludesFileList);
    }

    public void setIncludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.createInclude().setName(stringTokenizer.nextToken());
            }
        }
    }

    public void setExcludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.createExclude().setName(stringTokenizer.nextToken());
            }
        }
    }

    private final NameEntry addPatternToList(Vector vector) {
        NameEntry nameEntry = new NameEntry();
        vector.addElement(nameEntry);
        return nameEntry;
    }

    public void setIncludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createIncludesFile().setName(file.getAbsolutePath());
    }

    public void setExcludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createExcludesFile().setName(file.getAbsolutePath());
    }

    /*
     * Exception decompiling
     */
    private final void readPatterns(File var1_1, Vector var2_2, Project var3_3) throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void append(PatternSet patternSet, Project project) {
        String[] stringArray;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        String[] stringArray2 = patternSet.getIncludePatterns(project);
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                this.createInclude().setName(stringArray2[n]);
                ++n;
            }
        }
        if ((stringArray = patternSet.getExcludePatterns(project)) != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.createExclude().setName(stringArray[n]);
                ++n;
            }
        }
    }

    public String[] getIncludePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIncludePatterns(project);
        }
        this.readFiles(project);
        return this.makeArray(this.includeList, project);
    }

    public String[] getExcludePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getExcludePatterns(project);
        }
        this.readFiles(project);
        return this.makeArray(this.excludeList, project);
    }

    boolean hasPatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).hasPatterns(project);
        }
        boolean bl = false;
        if (this.includesFileList.size() > 0 || this.excludesFileList.size() > 0 || this.includeList.size() > 0 || this.excludeList.size() > 0) {
            bl = true;
        }
        return bl;
    }

    private final PatternSet getRef(Project project) {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<PatternSet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        if (!((object = this.getRefid().getReferencedObject(project)) instanceof PatternSet)) {
            String string = this.getRefid().getRefId() + " doesn't denote a patternset";
            throw new BuildException(string);
        }
        return (PatternSet)object;
    }

    private final String[] makeArray(Vector vector, Project project) {
        if (vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        Object[] objectArray = vector.elements();
        while (objectArray.hasMoreElements()) {
            NameEntry nameEntry = (NameEntry)objectArray.nextElement();
            String string = nameEntry.evalName(project);
            if (string == null || string.length() <= 0) continue;
            vector2.addElement(string);
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    private final void readFiles(Project project) {
        File file;
        String string;
        NameEntry nameEntry;
        Enumeration enumeration;
        if (this.includesFileList.size() > 0) {
            enumeration = this.includesFileList.elements();
            while (enumeration.hasMoreElements()) {
                nameEntry = (NameEntry)enumeration.nextElement();
                string = nameEntry.evalName(project);
                if (string == null) continue;
                file = project.resolveFile(string);
                if (!file.exists()) {
                    throw new BuildException("Includesfile " + file.getAbsolutePath() + " not found.");
                }
                this.readPatterns(file, this.includeList, project);
            }
            this.includesFileList.removeAllElements();
        }
        if (this.excludesFileList.size() > 0) {
            enumeration = this.excludesFileList.elements();
            while (enumeration.hasMoreElements()) {
                nameEntry = (NameEntry)enumeration.nextElement();
                string = nameEntry.evalName(project);
                if (string == null) continue;
                file = project.resolveFile(string);
                if (!file.exists()) {
                    throw new BuildException("Excludesfile " + file.getAbsolutePath() + " not found.");
                }
                this.readPatterns(file, this.excludeList, project);
            }
            this.excludesFileList.removeAllElements();
        }
    }

    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    public Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        try {
            PatternSet patternSet = (PatternSet)super.clone();
            patternSet.includeList = (Vector)this.includeList.clone();
            patternSet.excludeList = (Vector)this.excludeList.clone();
            patternSet.includesFileList = (Vector)this.includesFileList.clone();
            patternSet.excludesFileList = (Vector)this.excludesFileList.clone();
            return patternSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    private final /* synthetic */ void this() {
        this.includeList = new Vector();
        this.excludeList = new Vector();
        this.includesFileList = new Vector();
        this.excludesFileList = new Vector();
    }

    public PatternSet() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String string) {
            this.name = string;
        }

        public void setIf(String string) {
            this.ifCond = string;
        }

        public void setUnless(String string) {
            this.unlessCond = string;
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project project) {
            return this.valid(project) ? this.name : null;
        }

        private final boolean valid(Project project) {
            if (this.ifCond != null && project.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || project.getProperty(this.unlessCond) == null;
        }

        public String toString() {
            if (this.name == null) {
                throw new BuildException("Missing attribute \"name\" for a pattern");
            }
            StringBuffer stringBuffer = new StringBuffer(this.name);
            if (this.ifCond != null || this.unlessCond != null) {
                stringBuffer.append(":");
                String string = "";
                if (this.ifCond != null) {
                    stringBuffer.append("if->");
                    stringBuffer.append(this.ifCond);
                    string = ";";
                }
                if (this.unlessCond != null) {
                    stringBuffer.append(string);
                    stringBuffer.append("unless->");
                    stringBuffer.append(this.unlessCond);
                }
            }
            return stringBuffer.toString();
        }
    }
}

