/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.taskdefs.XSLTLiaison2;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XSLTProcess
extends MatchingTask
implements XSLTLogger {
    private static final String TRAX_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.TraXLiaison";
    private static final String XSLP_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.XslpLiaison";
    private static final String XALAN_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.XalanLiaison";
    private File destDir;
    private File baseDir;
    private String xslFile;
    private String targetExtension;
    private Vector params;
    private File inFile;
    private File outFile;
    private String processor;
    private Path classpath;
    private XSLTLiaison liaison;
    private boolean stylesheetLoaded;
    private boolean force;
    private FileUtils fileUtils;
    private Vector outputProperties;
    private XMLCatalog xmlCatalog;
    private boolean performDirectoryScan;
    private Factory factory;
    private boolean reuseLoadedStylesheet;
    private AntClassLoader loader;
    private Mapper mapperElement;

    public void setScanIncludedDirectories(boolean bl) {
        this.performDirectoryScan = bl;
    }

    public void setReloadStylesheet(boolean bl) {
        this.reuseLoadedStylesheet = bl ^ true;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = mapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File file = this.baseDir;
        if (this.xslFile == null) {
            throw new BuildException("no stylesheet specified", this.getLocation());
        }
        if (this.inFile != null && !this.inFile.exists()) {
            throw new BuildException("input file " + this.inFile.toString() + " does not exist", this.getLocation());
        }
        try {
            if (this.baseDir == null) {
                this.baseDir = this.getProject().resolveFile(".");
            }
            this.liaison = this.getLiaison();
            if (this.liaison instanceof XSLTLoggerAware) {
                ((XSLTLoggerAware)((Object)this.liaison)).setLogger(this);
            }
            this.log("Using " + this.liaison.getClass().toString(), 3);
            File file2 = this.getProject().resolveFile(this.xslFile);
            if (!file2.exists() && (file2 = this.fileUtils.resolveFile(this.baseDir, this.xslFile)).exists()) {
                this.log("DEPRECATED - the style attribute should be relative to the project's");
                this.log("             basedir, not the tasks's basedir.");
            }
            if (this.inFile != null && this.outFile != null) {
                this.process(this.inFile, this.outFile, file2);
                Object var6_3 = null;
                if (this.loader != null) {
                    this.loader.resetThreadContextLoader();
                    this.loader = null;
                }
                this.liaison = null;
                this.stylesheetLoaded = false;
                this.baseDir = file;
                return;
            }
            if (this.destDir == null) {
                String string = "destdir attributes must be set!";
                throw new BuildException(string);
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
            this.log("Transforming into " + this.destDir, 2);
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n = 0;
            while (n < stringArray.length) {
                this.process(this.baseDir, stringArray[n], this.destDir, file2);
                ++n;
            }
            if (this.performDirectoryScan) {
                String[] stringArray2 = directoryScanner.getIncludedDirectories();
                n = 0;
                while (n < stringArray2.length) {
                    stringArray = new File(this.baseDir, stringArray2[n]).list();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        this.process(this.baseDir, stringArray[n2], this.destDir, file2);
                        ++n2;
                    }
                    ++n;
                }
            }
            Object var6_5 = null;
            if (this.loader != null) {
                this.loader.resetThreadContextLoader();
                this.loader = null;
            }
            this.liaison = null;
            this.stylesheetLoaded = false;
            this.baseDir = file;
            return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (this.loader != null) {
                this.loader.resetThreadContextLoader();
                this.loader = null;
            }
            this.liaison = null;
            this.stylesheetLoaded = false;
            this.baseDir = file;
            throw throwable;
        }
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setExtension(String string) {
        this.targetExtension = string;
    }

    public void setStyle(String string) {
        this.xslFile = string;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setProcessor(String string) {
        this.processor = string;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xMLCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xMLCatalog);
    }

    private final void resolveProcessor(String string) throws Exception {
        if (string.equals("trax")) {
            Class clazz = this.loadClass(TRAX_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (string.equals("xslp")) {
            this.log("DEPRECATED - xslp processor is deprecated. Use trax instead.");
            Class clazz = this.loadClass(XSLP_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (string.equals("xalan")) {
            this.log("DEPRECATED - xalan processor is deprecated. Use trax instead.");
            Class clazz = this.loadClass(XALAN_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else {
            this.liaison = (XSLTLiaison)this.loadClass(string).newInstance();
        }
    }

    private final Class loadClass(String string) throws Exception {
        if (this.classpath == null) {
            return Class.forName(string);
        }
        this.loader = this.getProject().createClassLoader(this.classpath);
        this.loader.setThreadContextLoader();
        Class<?> clazz = Class.forName(string, true, this.loader);
        return clazz;
    }

    public void setOut(File file) {
        this.outFile = file;
    }

    public void setIn(File file) {
        this.inFile = file;
    }

    private final void process(File file, String string, File file2, File file3) throws BuildException {
        File file4 = null;
        File file5 = null;
        try {
            long l = file3.lastModified();
            file5 = new File(file, string);
            if (file5.isDirectory()) {
                this.log("Skipping " + file5 + " it is a directory.", 3);
                return;
            }
            FileNameMapper fileNameMapper = null;
            fileNameMapper = this.mapperElement != null ? this.mapperElement.getImplementation() : new StyleMapper();
            String[] stringArray = fileNameMapper.mapFileName(string);
            if (stringArray == null || stringArray.length == 0) {
                this.log("Skipping " + file5 + " it cannot get mapped to output.", 3);
                return;
            }
            if (stringArray == null || stringArray.length > 1) {
                this.log("Skipping " + file5 + " its mapping is ambiguos.", 3);
                return;
            }
            file4 = new File(file2, stringArray[0]);
            if (this.force || file5.lastModified() > file4.lastModified() || l > file4.lastModified()) {
                this.ensureDirectoryFor(file4);
                this.log("Processing " + file5 + " to " + file4);
                this.configureLiaison(file3);
                this.liaison.transform(file5, file4);
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file5, 2);
            if (file4 != null) {
                file4.delete();
            }
            throw new BuildException(exception);
        }
    }

    private final void process(File file, File file2, File file3) throws BuildException {
        try {
            long l = file3.lastModified();
            this.log("In file " + file + " time: " + file.lastModified(), 4);
            this.log("Out file " + file2 + " time: " + file2.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + l, 4);
            if (this.force || file.lastModified() >= file2.lastModified() || l >= file2.lastModified()) {
                this.ensureDirectoryFor(file2);
                this.log("Processing " + file + " to " + file2, 2);
                this.configureLiaison(file3);
                this.liaison.transform(file, file2);
            } else {
                this.log("Skipping input file " + file + " because it is older than output file " + file2 + " and so is the stylesheet " + file3, 4);
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file, 2);
            if (file2 != null) {
                file2.delete();
            }
            throw new BuildException(exception);
        }
    }

    private final void ensureDirectoryFor(File file) throws BuildException {
        File file2 = this.fileUtils.getParentFile(file);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new BuildException("Unable to create directory: " + file2.getAbsolutePath());
        }
    }

    public Factory getFactory() {
        return this.factory;
    }

    public XMLCatalog getXMLCatalog() {
        return this.xmlCatalog;
    }

    public Enumeration getOutputProperties() {
        return this.outputProperties.elements();
    }

    protected XSLTLiaison getLiaison() {
        if (this.liaison == null) {
            if (this.processor != null) {
                try {
                    this.resolveProcessor(this.processor);
                }
                catch (Exception exception) {
                    throw new BuildException(exception);
                }
            }
            try {
                this.resolveProcessor("trax");
            }
            catch (Throwable throwable) {
                try {
                    this.resolveProcessor("xalan");
                }
                catch (Throwable throwable2) {
                    try {
                        this.resolveProcessor("xslp");
                    }
                    catch (Throwable throwable3) {
                        throwable3.printStackTrace();
                        throwable2.printStackTrace();
                        throw new BuildException(throwable);
                    }
                }
            }
        }
        return this.liaison;
    }

    public Param createParam() {
        Param param = new Param();
        this.params.addElement(param);
        return param;
    }

    public OutputProperty createOutputProperty() {
        OutputProperty outputProperty = new OutputProperty();
        this.outputProperties.addElement(outputProperty);
        return outputProperty;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected void configureLiaison(File file) throws BuildException {
        if (this.stylesheetLoaded && this.reuseLoadedStylesheet) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            this.log("Loading stylesheet " + file, 2);
            this.liaison.setStylesheet(file);
            Enumeration enumeration = this.params.elements();
            while (enumeration.hasMoreElements()) {
                Param param = (Param)enumeration.nextElement();
                if (!param.shouldUse()) continue;
                this.liaison.addParam(param.getName(), param.getExpression());
            }
            if (this.liaison instanceof XSLTLiaison2) {
                ((XSLTLiaison2)this.liaison).configure(this);
            }
        }
        catch (Exception exception) {
            this.log("Failed to transform using stylesheet " + file, 2);
            throw new BuildException(exception);
        }
    }

    public Factory createFactory() throws BuildException {
        if (this.factory != null) {
            throw new BuildException("'factory' element must be unique");
        }
        this.factory = new Factory();
        return this.factory;
    }

    private final /* synthetic */ void this() {
        this.destDir = null;
        this.baseDir = null;
        this.xslFile = null;
        this.targetExtension = ".html";
        this.params = new Vector();
        this.inFile = null;
        this.outFile = null;
        this.classpath = null;
        this.stylesheetLoaded = false;
        this.force = false;
        this.outputProperties = new Vector();
        this.xmlCatalog = new XMLCatalog();
        this.performDirectoryScan = true;
        this.factory = null;
        this.reuseLoadedStylesheet = true;
        this.loader = null;
        this.mapperElement = null;
    }

    public XSLTProcess() {
        this.this();
        this.fileUtils = FileUtils.newFileUtils();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class StyleMapper
    implements FileNameMapper {
        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            return new String[]{string + XSLTProcess.this.targetExtension};
        }

        private StyleMapper() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Param {
        private String name;
        private String expression;
        private String ifProperty;
        private String unlessProperty;
        private Project project;

        public void setProject(Project project) {
            this.project = project;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }

        public void setIf(String string) {
            this.ifProperty = string;
        }

        public void setUnless(String string) {
            this.unlessProperty = string;
        }

        public boolean shouldUse() {
            if (this.ifProperty != null && this.project.getProperty(this.ifProperty) == null) {
                return false;
            }
            return this.unlessProperty == null || this.project.getProperty(this.unlessProperty) == null;
        }

        private final /* synthetic */ void this() {
            this.name = null;
            this.expression = null;
        }

        public Param() {
            this.this();
        }
    }

    public static class OutputProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Factory {
        private String name;
        private Vector attributes;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void addAttribute(Attribute attribute) {
            this.attributes.addElement(attribute);
        }

        public Enumeration getAttributes() {
            return this.attributes.elements();
        }

        private final /* synthetic */ void this() {
            this.attributes = new Vector();
        }

        public Factory() {
            this.this();
        }

        public static class Attribute
        implements DynamicConfigurator {
            private String name;
            private Object value;

            public String getName() {
                return this.name;
            }

            public Object getValue() {
                return this.value;
            }

            public Object createDynamicElement(String string) throws BuildException {
                return null;
            }

            public void setDynamicAttribute(String string, String string2) throws BuildException {
                if ("name".equalsIgnoreCase(string)) {
                    this.name = string2;
                } else if ("value".equalsIgnoreCase(string)) {
                    if ("true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2)) {
                        this.value = new Boolean(string2);
                    } else {
                        try {
                            this.value = new Integer(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.value = string2;
                        }
                    }
                } else {
                    throw new BuildException("Unsupported attribute: " + string);
                }
            }
        }
    }
}

