/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.scanner.ScannerException;

public class AttributeDefault
extends Declaration {
    private String value;
    private boolean required;
    private boolean implied;
    private boolean fixed;
    private boolean hasDefault;

    public AttributeDefault() {
        this.init();
    }

    public void init() {
        super.init();
        this.required = false;
        this.implied = false;
        this.fixed = false;
        this.hasDefault = false;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isImplied() {
        return this.implied;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        switch (baseParser.getCurrentToken().tokenType) {
            case 50: {
                baseParser.accept();
                this.implied = true;
                break;
            }
            case 49: {
                baseParser.accept();
                this.required = true;
                break;
            }
            case 51: {
                baseParser.accept();
                this.fixed = true;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                this.value = "";
                while (baseParser.compare(13) || baseParser.compare(14) || baseParser.compare(15) || baseParser.compare(19)) {
                    this.value = baseParser.compare(15) || baseParser.compare(14) ? this.value + baseParser.getCurrentToken().text : (baseParser.compare(19) ? this.value + " " : this.value + baseParser.getCurrentToken().getArrayAsString());
                    baseParser.accept();
                    this.hasDefault = true;
                }
                break;
            }
            default: {
                throw new ParseException("Default declarations must be #REQUIRED, #IMPLIED or #FIXED", baseParser.getLine(), baseParser.getCurrentToken());
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.required) {
            return "#REQUIRED";
        }
        if (this.implied) {
            return "#IMPLIED";
        }
        if (this.fixed) {
            return "#FIXED \"" + this.value + "\"";
        }
        return "\"" + this.value + "\"";
    }
}

