/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvproto.ft.FileTransferHeader;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import org.jetbrains.annotations.Nullable;

public class TransferredFileImpl
implements TransferredFile {
    @Nullable
    private final RandomAccessFile raf;
    private final long size;
    private final File file;
    private final String name;
    private final long lastmod;
    private ByteBlock macFileInfo = FileTransferHeader.MACFILEINFO_DEFAULT;

    protected TransferredFileImpl(@Nullable RandomAccessFile raf, long size, File file, String name, long lastmod) {
        this.raf = raf;
        this.size = size;
        this.file = file;
        this.name = name;
        this.lastmod = lastmod;
    }

    public TransferredFileImpl(File file, String name, String fileMode) throws IOException {
        this.file = file;
        this.name = name;
        this.raf = new RandomAccessFile(file, fileMode);
        this.size = this.raf.length();
        this.lastmod = file.lastModified();
    }

    public long getSize() {
        return this.size;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public String getTransferredName() {
        return this.name;
    }

    public File getRealFile() {
        return this.file;
    }

    public long getLastModifiedMillis() {
        return this.lastmod;
    }

    public FileChannel getChannel() {
        if (this.raf == null) {
            throw new IllegalStateException("This file does not have a RandomAccessFile. It was probably created for unit testing.");
        }
        return this.raf.getChannel();
    }

    public ByteBlock getMacFileInfo() {
        return this.macFileInfo;
    }

    public void setMacFileInfo(ByteBlock macFileInfo) {
        this.macFileInfo = macFileInfo;
    }
}

