/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.icbm.AbstractRvIcbm;
import net.kano.joscar.snaccmd.icbm.RecvIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.TlvTools;

public class RecvRvIcbm
extends AbstractRvIcbm
implements RecvIcbm {
    private final FullUserInfo sender;

    protected RecvRvIcbm(SnacPacket snacPacket) {
        super(7, snacPacket);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = this.getChannelData();
        this.sender = FullUserInfo.readUserInfo(byteBlock);
        ByteBlock byteBlock2 = byteBlock.subBlock(this.sender.getTotalSize());
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.processRvTlvs(immutableTlvChain);
    }

    public RecvRvIcbm(long l, int n, long l2, CapabilityBlock capabilityBlock, LiveWritable liveWritable, FullUserInfo fullUserInfo) {
        super(7, l, n, l2, capabilityBlock, liveWritable);
        DefensiveTools.checkNull(fullUserInfo, "sender");
        this.sender = fullUserInfo;
    }

    public final FullUserInfo getSenderInfo() {
        return this.sender;
    }

    protected final void writeChannelData(OutputStream outputStream) throws IOException {
        this.sender.write(outputStream);
        this.writeRvTlvs(outputStream);
    }

    public String toString() {
        return "RecvRvIcbm: sender=<" + this.sender + ">, on top of " + super.toString();
    }
}

