/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FixCRLF
extends MatchingTask {
    private static final int UNDEF = -1;
    private static final int NOTJAVA = 0;
    private static final int LOOKING = 1;
    private static final int IN_CHAR_CONST = 2;
    private static final int IN_STR_CONST = 3;
    private static final int IN_SINGLE_COMMENT = 4;
    private static final int IN_MULTI_COMMENT = 5;
    private static final int ASIS = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CRLF = 3;
    private static final int ADD = 1;
    private static final int REMOVE = -1;
    private static final int SPACES = -1;
    private static final int TABS = 1;
    private static final int INBUFLEN = 8192;
    private static final int LINEBUFLEN = 200;
    private static final char CTRLZ = '\u001a';
    private int tablength;
    private String spaces;
    private StringBuffer linebuf;
    private StringBuffer linebuf2;
    private int eol;
    private String eolstr;
    private int ctrlz;
    private int tabs;
    private boolean javafiles;
    private boolean fixlast;
    private File srcDir;
    private File destDir;
    private FileUtils fileUtils;
    private String encoding;

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setJavafiles(boolean bl) {
        this.javafiles = bl;
    }

    public void setEol(CrLf crLf) {
        String string = crLf.getValue();
        if (string.equals("asis")) {
            this.eol = 0;
        } else if (string.equals("cr") || string.equals("mac")) {
            this.eol = 1;
            this.eolstr = "\r";
        } else if (string.equals("lf") || string.equals("unix")) {
            this.eol = 2;
            this.eolstr = "\n";
        } else {
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setCr(AddAsisRemove addAsisRemove) {
        this.log("DEPRECATED: The cr attribute has been deprecated,", 1);
        this.log("Please use the eol attribute instead", 1);
        String string = addAsisRemove.getValue();
        CrLf crLf = new CrLf();
        if (string.equals("remove")) {
            crLf.setValue("lf");
        } else if (string.equals("asis")) {
            crLf.setValue("asis");
        } else {
            crLf.setValue("crlf");
        }
        this.setEol(crLf);
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.tabs = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTablength(int n) throws BuildException {
        if (n < 2 || n > 80) {
            throw new BuildException("tablength must be between 2 and 80", this.getLocation());
        }
        this.tablength = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.tablength) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.spaces = stringBuffer.toString();
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.ctrlz = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setFixlast(boolean bl) {
        this.fixlast = bl;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: eol=" + (this.eol == 0 ? "asis" : (this.eol == 1 ? "cr" : (this.eol == 2 ? "lf" : "crlf"))) + " tab=" + (this.tabs == 1 ? "add" : (this.tabs == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength + " encoding=" + (this.encoding == null ? "default" : this.encoding), 3);
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            this.processFile(stringArray[n]);
            ++n;
        }
    }

    private final Reader getReader(File file) throws IOException {
        return this.encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processFile(String var1_1) throws BuildException {
        block51: {
            var2_2 = new File(this.srcDir, var1_1);
            var3_3 = this.destDir == null ? this.srcDir : this.destDir;
            var4_4 = null;
            var7_5 = new OneLiner(var2_2);
            try {
                block49: {
                    try {
                        try {
                            var4_4 = this.fileUtils.createTempFile("fixcrlf", "", null);
                            var4_4.deleteOnExit();
                            var11_6 /* !! */  = this.encoding == null ? new FileWriter(var4_4) : new OutputStreamWriter((OutputStream)new FileOutputStream(var4_4), this.encoding);
                            var5_11 = new BufferedWriter(var11_6 /* !! */ );
                            ** GOTO lbl15
                        }
                        catch (IOException var11_7) {
                            throw new BuildException(var11_7);
lbl15:
                            // 1 sources

                            if (true) ** GOTO lbl80
                        }
                    }
                    catch (IOException var11_10) {
                        throw new BuildException(var11_10);
                        do {
                            try {
                                var6_12 = (OneLiner.BufferLine)var7_5.nextElement();
                            }
                            catch (NoSuchElementException var12_14) {
                                throw new BuildException(var12_14);
                            }
                            var12_13 = var6_12.getLineString();
                            var13_15 = var6_12.length();
                            if (this.tabs != 0) ** GOTO lbl73
                            try {
                                var5_11.write(var12_13);
                            }
                            catch (IOException var14_20) {
                                throw new BuildException(var14_20);
                            }
lbl-1000:
                            // 1 sources

                            {
                                switch (var7_5.getState()) {
                                    case 0: {
                                        this.notInConstant(var6_12, var6_12.length(), var5_11);
                                        break;
                                    }
                                    case 5: {
                                        var11_8 = var12_13.indexOf("*/", var6_12.getNext());
                                        if (var11_8 >= 0) {
                                            var11_8 += 2;
                                            var7_5.setState(1);
                                        } else {
                                            var11_8 = var13_15;
                                        }
                                        this.notInConstant(var6_12, var11_8, var5_11);
                                        break;
                                    }
                                    case 4: {
                                        this.notInConstant(var6_12, var6_12.length(), var5_11);
                                        var7_5.setState(1);
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        var14_19 = var6_12.getNext();
                                        var15_23 = var7_5.getState() == 3 ? '\"' : '\'';
                                        this.endOfCharConst(var6_12, var15_23);
                                        while (true) {
                                            if (var6_12.getNext() >= var6_12.getLookahead()) {
                                                ** try [egrp 5[TRYBLOCK] [3 : 437->457)] { 
lbl56:
                                                // 1 sources

                                                break;
                                            }
                                            if (var6_12.getNextCharInc() == '\t') {
                                                var6_12.setColumn(var6_12.getColumn() + this.tablength - var6_12.getColumn() % this.tablength);
                                                continue;
                                            }
                                            var6_12.incColumn();
                                        }
                                        {
                                            var5_11.write(var6_12.substring(var14_19, var6_12.getNext()));
                                        }
lbl65:
                                        // 1 sources

                                        catch (IOException var16_24) {
                                            throw new BuildException(var16_24);
                                        }
                                        var7_5.setState(1);
                                        break;
                                    }
                                    case 1: {
                                        this.nextStateChange(var6_12);
                                        this.notInConstant(var6_12, var6_12.getLookahead(), var5_11);
                                        break;
                                    }
                                }
lbl73:
                                // 7 sources

                                ** while (var6_12.getNext() < var13_15)
                            }
lbl74:
                            // 2 sources

                            if ("".equals(var6_12.getEol()) && !this.fixlast) continue;
                            try {
                                var5_11.write(this.eolstr);
                            }
                            catch (IOException var14_21) {
                                throw new BuildException(var14_21);
                            }
lbl80:
                            // 3 sources

                        } while (var7_5.hasMoreElements());
                        try {
                            block48: {
                                try {
                                    if (this.ctrlz == 0) {
                                        var5_11.write(var7_5.getEofStr());
                                        break block48;
                                    }
                                    if (this.ctrlz == 1) {
                                        var5_11.write(26);
                                    }
                                }
                                catch (IOException var14_22) {
                                    throw new BuildException(var14_22);
                                }
                            }
                            var12_13 = null;
                        }
                        catch (Throwable var11_9) {
                            var12_13 = null;
                            try {
                                var5_11.close();
                                throw var11_9;
                            }
                            catch (IOException var13_16) {
                                throw new BuildException(var13_16);
                            }
                        }
                        try {}
                        catch (IOException var13_17) {
                            throw new BuildException(var13_17);
                        }
                        var5_11.close();
                        {
                            var7_5.close();
                            var7_5 = null;
                        }
                        var13_18 = new File(var3_3, var1_1);
                        var14_19 = 1;
                        if (var13_18.exists()) {
                            this.log("destFile exists", 4);
                            if (!this.fileUtils.contentEquals(var13_18, var4_4)) {
                                this.log(var13_18 + " is being written", 4);
                            } else {
                                this.log(var13_18 + " is not written, as the contents are identical", 4);
                                var14_19 = 0;
                            }
                        }
                        if (var14_19 == 0) break block49;
                        this.fileUtils.rename(var4_4, var13_18);
                        var4_4 = null;
                    }
                }
                var9_27 = null;
            }
            catch (Throwable var8_25) {
                var9_26 = null;
                try {
                    if (var7_5 != null) {
                        var7_5.close();
                    }
                }
                catch (IOException var10_28) {
                    this.log("Error closing " + var2_2, 0);
                }
                if (var4_4 == null) throw var8_25;
                var4_4.delete();
                throw var8_25;
            }
            ** try [egrp 12[TRYBLOCK] [12 : 832->845)] { 
lbl140:
            // 1 sources

            if (var7_5 != null) {
                var7_5.close();
            }
            break block51;
lbl143:
            // 1 sources

            catch (IOException var10_29) {
                this.log("Error closing " + var2_2, 0);
            }
        }
        if (var4_4 == null) return;
        var4_4.delete();
    }

    private final void nextStateChange(OneLiner.BufferLine bufferLine) throws BuildException {
        int n = bufferLine.length();
        int n2 = bufferLine.getNext();
        block5: while (n2 < n) {
            switch (bufferLine.getChar(n2++)) {
                case '\'': {
                    bufferLine.setState(2);
                    bufferLine.setLookahead(--n2);
                    return;
                }
                case '\"': {
                    bufferLine.setState(3);
                    bufferLine.setLookahead(--n2);
                    return;
                }
                case '/': {
                    if (n2 >= n) continue block5;
                    if (bufferLine.getChar(n2) == '*') {
                        bufferLine.setState(5);
                        bufferLine.setLookahead(--n2);
                        return;
                    }
                    if (bufferLine.getChar(n2) != '/') continue block5;
                    bufferLine.setState(4);
                    bufferLine.setLookahead(--n2);
                    return;
                }
            }
        }
        bufferLine.setLookahead(n2);
    }

    private final void endOfCharConst(OneLiner.BufferLine bufferLine, char c) throws BuildException {
        int n = bufferLine.getNext();
        int n2 = bufferLine.length();
        ++n;
        while (n < n2) {
            char c2;
            if ((c2 = bufferLine.getChar(n++)) == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            bufferLine.setLookahead(n);
            return;
        }
        throw new BuildException("endOfCharConst: unterminated char constant");
    }

    private final void notInConstant(OneLiner.BufferLine bufferLine, int n, BufferedWriter bufferedWriter) {
        int n2;
        String string = bufferLine.substring(bufferLine.getNext(), n);
        int n3 = 0;
        int n4 = bufferLine.getColumn();
        this.linebuf = new StringBuffer();
        while ((n2 = string.indexOf(9, n3)) >= 0) {
            this.linebuf.append(string.substring(n3, n2));
            int n5 = this.tablength - (n4 += n2 - n3) % this.tablength;
            this.linebuf.append(this.spaces.substring(0, n5));
            n4 += n5;
            n3 = n2 + 1;
        }
        this.linebuf.append(string.substring(n3, string.length()));
        String string2 = new String(this.linebuf.substring(0));
        if (this.tabs == -1) {
            try {
                bufferedWriter.write(string2);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        }
        this.linebuf2 = new StringBuffer();
        n3 = 0;
        int n6 = n4 = bufferLine.getColumn();
        int n7 = n4 + (this.tablength - n4 % this.tablength);
        if (n7 - n4 < 2) {
            this.linebuf2.append(string2.substring(n3, n7 - n6));
            n3 = n7 - n6;
            n7 += this.tablength;
        }
        while (n7 - n6 <= string2.length()) {
            int n8 = n7;
            while (--n8 - n6 >= n3 && string2.charAt(n8 - n6) == ' ') {
            }
            if (n7 - n8 > 2) {
                this.linebuf2.append(string2.substring(n3, ++n8 - n6));
                this.linebuf2.append('\t');
            } else {
                this.linebuf2.append(string2.substring(n3, n7 - n6));
            }
            n3 = n7 - n6;
            n7 += this.tablength;
        }
        this.linebuf2.append(string2.substring(n3, string2.length()));
        try {
            bufferedWriter.write(this.linebuf2.substring(0));
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        bufferLine.setColumn(bufferLine.getColumn() + string2.length());
        bufferLine.setNext(n);
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    static /* synthetic */ int access$2() {
        return 0;
    }

    static /* synthetic */ int access$3() {
        return 200;
    }

    static /* synthetic */ int access$4() {
        return -1;
    }

    static /* synthetic */ int access$6() {
        return 8192;
    }

    static /* synthetic */ char access$7() {
        return '\u001a';
    }

    private final /* synthetic */ void this() {
        this.tablength = 8;
        this.spaces = "        ";
        this.linebuf = new StringBuffer(1024);
        this.linebuf2 = new StringBuffer(1024);
        this.javafiles = false;
        this.fixlast = true;
        this.destDir = null;
        this.fileUtils = FileUtils.newFileUtils();
        this.encoding = null;
    }

    public FixCRLF() {
        this.this();
        this.tabs = 0;
        if (Os.isFamily("mac")) {
            this.ctrlz = -1;
            this.eol = 1;
            this.eolstr = "\r";
        } else if (Os.isFamily("dos")) {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        } else {
            this.ctrlz = -1;
            this.eol = 2;
            this.eolstr = "\n";
        }
    }

    public static class CrLf
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"asis", "cr", "lf", "crlf", "mac", "unix", "dos"};
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OneLiner
    implements Enumeration {
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private StringBuffer line;
        private boolean reachedEof;
        private File srcFile;

        protected void nextLine() throws BuildException {
            int n = -1;
            int n2 = 0;
            this.eolStr = new StringBuffer();
            this.line = new StringBuffer();
            try {
                n = this.reader.read();
                while (n != -1 && n != 13 && n != 10) {
                    this.line.append((char)n);
                    n = this.reader.read();
                }
                if (n == -1 && this.line.length() == 0) {
                    this.reachedEof = true;
                    return;
                }
                block1 : switch ((char)n) {
                    case '\r': {
                        ++n2;
                        this.eolStr.append('\r');
                        this.reader.mark(2);
                        n = this.reader.read();
                        switch (n) {
                            case 13: {
                                n = this.reader.read();
                                if ((char)n == '\n') {
                                    n2 += 2;
                                    this.eolStr.append("\r\n");
                                    break block1;
                                }
                                this.reader.reset();
                                break block1;
                            }
                            case 10: {
                                ++n2;
                                this.eolStr.append('\n');
                                break block1;
                            }
                            case -1: {
                                break block1;
                            }
                        }
                        this.reader.reset();
                        break;
                    }
                    case '\n': {
                        ++n2;
                        this.eolStr.append('\n');
                        break;
                    }
                }
                if (n2 == 0) {
                    int n3 = this.line.length();
                    while (--n3 >= 0 && this.line.charAt(n3) == '\u001a') {
                    }
                    if (n3 < this.line.length() - 1) {
                        this.eofStr.append(this.line.toString().substring(n3 + 1));
                        if (n3 < 0) {
                            this.line.setLength(0);
                            this.reachedEof = true;
                        } else {
                            this.line.setLength(n3 + 1);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException(this.srcFile + ": " + iOException.getMessage(), iOException, FixCRLF.this.getLocation());
            }
        }

        public String getEofStr() {
            return this.eofStr.substring(0);
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        public boolean hasMoreElements() {
            return this.reachedEof ^ true;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine bufferLine = new BufferLine(this.line.toString(), this.eolStr.substring(0));
            this.nextLine();
            return bufferLine;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private final /* synthetic */ void this() {
            this.state = FixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.line = new StringBuffer();
            this.reachedEof = false;
        }

        public OneLiner(File file) throws BuildException {
            this.this();
            this.srcFile = file;
            try {
                this.reader = new BufferedReader(FixCRLF.this.getReader(file), 8192);
                this.nextLine();
            }
            catch (IOException iOException) {
                throw new BuildException(file + ": " + iOException.getMessage(), iOException, FixCRLF.this.getLocation());
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class BufferLine {
            private int next;
            private int column;
            private int lookahead;
            private String line;
            private String eolStr;

            public int getNext() {
                return this.next;
            }

            public void setNext(int n) {
                this.next = n;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public void setLookahead(int n) {
                this.lookahead = n;
            }

            public char getChar(int n) {
                return this.line.charAt(n);
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getColumn() {
                return this.column;
            }

            public void setColumn(int n) {
                this.column = n;
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public String getEol() {
                return this.eolStr;
            }

            public String substring(int n) {
                return this.line.substring(n);
            }

            public String substring(int n, int n2) {
                return this.line.substring(n, n2);
            }

            public void setState(int n) {
                OneLiner.this.setState(n);
            }

            public int getState() {
                return OneLiner.this.getState();
            }

            private final /* synthetic */ void this() {
                this.next = 0;
                this.column = 0;
                this.lookahead = -1;
            }

            public BufferLine(String string, String string2) throws BuildException {
                this.this();
                this.next = 0;
                this.column = 0;
                this.line = string;
                this.eolStr = string2;
            }
        }
    }
}

