/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SubDirInfoTask
extends Task {
    public static final String DEFAULT_DELIM = ",";
    private File dir;
    private String property;
    private String delimiter;
    private String ifexists;
    private String except;

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return DEFAULT_DELIM;
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getIfexists() {
        return this.ifexists;
    }

    public void setIfexists(String ifexists) {
        this.ifexists = ifexists;
    }

    public String getExcept() {
        return this.except;
    }

    public void setExcept(String except) {
        this.except = except;
    }

    public void execute() throws BuildException {
        File[] subdirs = this.dir.listFiles();
        StringBuffer buf = new StringBuffer();
        String value = null;
        String sep = "";
        for (int i = 0; i < subdirs.length; ++i) {
            File subdir = subdirs[i];
            boolean add = false;
            if (subdir.isDirectory()) {
                if (this.getIfexists() != null) {
                    File file = new File(subdir, this.getIfexists());
                    if (file.exists()) {
                        add = true;
                    }
                } else {
                    add = true;
                }
            }
            if (!add || subdir.getName().equals(this.except)) continue;
            buf.append(sep).append(subdir.getName());
            sep = this.getDelimiter();
        }
        if (buf.length() > 0) {
            value = buf.toString();
        }
        if (value == null) {
            this.log("No tokens found.", 4);
        } else {
            this.log("Setting property '" + this.property + "' to " + value, 4);
            if (buf.length() >= 0) {
                this.getProject().setProperty(this.property, value);
            }
        }
    }
}

