/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

public class RateInfoCmd
extends ConnCommand {
    private final RateClassInfo[] infos;

    protected RateInfoCmd(SnacPacket snacPacket) {
        super(7);
        int n;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        System.out.println("len: " + byteBlock.getLength());
        int n2 = BinaryTools.getUShort(byteBlock, 0);
        RateClassInfo[] rateClassInfoArray = new RateClassInfo[n2];
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        for (n = 0; n < n2; ++n) {
            rateClassInfoArray[n] = RateClassInfo.readRateClassInfo(byteBlock2);
            byteBlock2 = byteBlock2.subBlock((int)rateClassInfoArray[n].getWritableLength());
        }
        for (n = 0; n < n2; ++n) {
            int n3 = BinaryTools.getUShort(byteBlock2, 0);
            int n4 = BinaryTools.getUShort(byteBlock2, 2);
            CmdType[] cmdTypeArray = new CmdType[n4];
            if (n3 != rateClassInfoArray[n].getRateClass()) continue;
            for (int i = 0; i < n4; ++i) {
                int n5 = BinaryTools.getUShort(byteBlock2, 4 + i * 4);
                int n6 = BinaryTools.getUShort(byteBlock2, 4 + i * 4 + 2);
                cmdTypeArray[i] = new CmdType(n5, n6);
            }
            rateClassInfoArray[n].setCommands(cmdTypeArray);
            byteBlock2 = byteBlock2.subBlock(4 + n4 * 4);
        }
        this.infos = rateClassInfoArray;
    }

    public RateInfoCmd(RateClassInfo[] rateClassInfoArray) {
        super(7);
        this.infos = (RateClassInfo[])(rateClassInfoArray == null ? null : rateClassInfoArray.clone());
    }

    public RateClassInfo[] getRateClassInfos() {
        return (RateClassInfo[])(this.infos == null ? null : this.infos.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        int n = this.infos == null ? 0 : this.infos.length;
        BinaryTools.writeUShort(outputStream, n);
        if (this.infos != null) {
            int n2;
            for (n2 = 0; n2 < this.infos.length; ++n2) {
                this.infos[n2].write(outputStream);
            }
            for (n2 = 0; n2 < this.infos.length; ++n2) {
                CmdType[] cmdTypeArray = this.infos[n2].getCommands();
                for (int i = 0; i < cmdTypeArray.length; ++i) {
                    BinaryTools.writeUShort(outputStream, cmdTypeArray[i].getFamily());
                    BinaryTools.writeUShort(outputStream, cmdTypeArray[i].getCommand());
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RateInfoCmd: ");
        for (int i = 0; i < this.infos.length; ++i) {
            stringBuffer.append(this.infos[i]);
            stringBuffer.append(" - ");
        }
        return stringBuffer.toString();
    }
}

