/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.postgresql.Driver;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public abstract class AbstractJdbc2Blob {
    private int oid;
    private LargeObject lo;

    public AbstractJdbc2Blob(PGConnection conn, int oid) throws SQLException {
        this.oid = oid;
        LargeObjectManager lom = conn.getLargeObjectAPI();
        this.lo = lom.open(oid);
    }

    public long length() throws SQLException {
        return this.lo.size();
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.lo.getInputStream();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.lo.seek((int)pos, 0);
        return this.lo.read(length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw Driver.notImplemented();
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }
}

