/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.nio.ByteBuffer;

public class NumberUtils {
    public static boolean isDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            if (!bl && c == '.') {
                bl = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static byte stringToByte(String string, byte by) {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return by;
        }
    }

    public static byte stringToByte(String string) {
        return NumberUtils.stringToByte(string, (byte)0);
    }

    public static short stringToShort(String string, short s) {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    public static short stringToShort(String string) {
        return NumberUtils.stringToShort(string, (short)0);
    }

    public static int stringToInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static int stringToInt(String string) {
        return NumberUtils.stringToInt(string, 0);
    }

    public static long stringToLong(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static long stringToLong(String string) {
        return NumberUtils.stringToLong(string, 0L);
    }

    public static float stringToFloat(String string, float f) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static float stringToFloat(String string) {
        return NumberUtils.stringToFloat(string, 0.0f);
    }

    public static String toHexValue(ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.remaining() * 2);
        while (byteBuffer.hasRemaining()) {
            String string = Integer.toHexString(byteBuffer.get() & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String toHexValue(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(0, l);
        return NumberUtils.toHexValue(byteBuffer);
    }

    public static String toHexValue(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(0, n);
        return NumberUtils.toHexValue(byteBuffer);
    }

    public static String toHexValue(short s) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.putShort(0, s);
        return NumberUtils.toHexValue(byteBuffer);
    }

    public static String toHexValue(byte by) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.put(0, by);
        return NumberUtils.toHexValue(byteBuffer);
    }
}

