/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.TlvTools;

public class RvResponse
extends IcbmCommand {
    public static final int CODE_NOT_SUPPORTED = 0;
    public static final int CODE_DECLINED = 1;
    public static final int CODE_NOT_ACCEPTING = 2;
    private static final int TYPE_RESULT_CODE = 3;
    private final long rvSessionId;
    private final int channel;
    private final String sn;
    private final int code;

    protected RvResponse(SnacPacket packet) {
        super(11);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.rvSessionId = BinaryTools.getLong((ByteBlock)snacData, (int)0);
        this.channel = BinaryTools.getUShort((ByteBlock)snacData, (int)8);
        ByteBlock snData = snacData.subBlock(10);
        StringBlock snInfo = OscarTools.readScreenname(snData);
        this.sn = snInfo.getString();
        ByteBlock rest = snData.subBlock(snInfo.getTotalSize());
        ImmutableTlvChain chain = TlvTools.readChain(rest);
        this.code = chain.getUShort(3);
    }

    public RvResponse(long rvSessionId, int icbmChannel, String sn, int resultCode) {
        super(11);
        DefensiveTools.checkRange((int)icbmChannel, (String)"icbmChannel", (int)0);
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        DefensiveTools.checkRange((int)resultCode, (String)"resultCode", (int)-1);
        this.rvSessionId = rvSessionId;
        this.channel = icbmChannel;
        this.sn = sn;
        this.code = resultCode;
    }

    public final long getRvSessionId() {
        return this.rvSessionId;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getResultCode() {
        return this.code;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeLong((OutputStream)out, (long)this.rvSessionId);
        BinaryTools.writeUShort((OutputStream)out, (int)this.channel);
        OscarTools.writeScreenname(out, this.sn);
        BinaryTools.writeUShort((OutputStream)out, (int)this.code);
    }

    public String toString() {
        return "RvResponse: sn=" + this.sn + ": icbmChannel=" + this.channel + ", code=0x" + Integer.toHexString(this.code);
    }
}

