/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enums {
    public static <T extends Enum<T>> T valueOf(Class<T> enumClass, String value, T defaultValue) {
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumClass, String value) {
        return Enums.valueOf(enumClass, value, null);
    }

    public static <T extends Enum<T>> EnumSet<T> fromBitMask(Class<T> enumClass, Number mask) {
        EnumSet<T> set = EnumSet.noneOf(enumClass);
        long bits = mask.longValue();
        for (Enum type : (Enum[])enumClass.getEnumConstants()) {
            int intValue = 1 << type.ordinal();
            if ((bits & (long)intValue) != (long)intValue) continue;
            set.add(type);
        }
        return set;
    }

    public static <T extends Enum<T>> long toBitMask(Set<T> set) {
        long bits = 0L;
        for (Enum type : set) {
            bits |= (long)(1 << type.ordinal());
        }
        return bits;
    }
}

