/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.TraversalCheckingVisitor;

public class MethodCallingVisitor
extends TraversalCheckingVisitor
implements Serializable {
    private transient Method method;
    private final Object[] arguments;
    private final Class type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;

    public MethodCallingVisitor(Method method, Class ofType, Object[] arguments, boolean visitInInstantiationOrder) {
        if (method == null) {
            throw new NullPointerException();
        }
        this.method = method;
        this.arguments = arguments;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList();
    }

    public MethodCallingVisitor(Method method, Class ofType, Object[] arguments) {
        this(method, ofType, arguments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            Iterator iterator = this.componentInstances.iterator();
            while (iterator.hasNext()) {
                this.invoke(iterator.next());
            }
        }
        finally {
            this.componentInstances.clear();
        }
        return Void.TYPE;
    }

    public void visitContainer(PicoContainer pico) {
        super.visitContainer(pico);
        this.componentInstances.addAll(pico.getComponentInstancesOfType(this.type));
    }

    protected Method getMethod() {
        return this.method;
    }

    protected Object[] getArguments() {
        return this.arguments;
    }

    protected void invoke(Object[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            this.invoke(targets[i]);
        }
    }

    protected Object invoke(Object target) {
        Method method = this.getMethod();
        try {
            method.invoke(target, this.getArguments());
        }
        catch (IllegalArgumentException e) {
            throw new PicoIntrospectionException("Can't call " + method.getName() + " on " + target, e);
        }
        catch (IllegalAccessException e) {
            throw new PicoIntrospectionException("Can't call " + method.getName() + " on " + target, e);
        }
        catch (InvocationTargetException e) {
            throw new PicoIntrospectionException("Failed when calling " + method.getName() + " on " + target, e.getTargetException());
        }
        return Void.TYPE;
    }
}

