/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PrivacyList;
import org.jivesoftware.smack.PrivacyListListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Privacy;
import org.jivesoftware.smack.packet.PrivacyItem;

public class PrivacyListManager {
    private static Map<Connection, PrivacyListManager> instances = new Hashtable<Connection, PrivacyListManager>();
    private Connection connection;
    private final List<PrivacyListListener> listeners = new ArrayList<PrivacyListListener>();
    PacketFilter packetFilter = new AndFilter(new IQTypeFilter(IQ.Type.SET), new PacketExtensionFilter("query", "jabber:iq:privacy"));

    private PrivacyListManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    private String getUser() {
        return this.connection.getUser();
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                instances.remove(PrivacyListManager.this.connection);
            }

            @Override
            public void connectionClosedOnError(Exception e) {
            }

            @Override
            public void reconnectionFailed(Exception e) {
            }

            @Override
            public void reconnectingIn(int seconds) {
            }

            @Override
            public void reconnectionSuccessful() {
            }
        });
        this.connection.addPacketListener(new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processPacket(Packet packet) {
                if (packet == null || packet.getError() != null) {
                    return;
                }
                Privacy privacy = (Privacy)packet;
                List list = PrivacyListManager.this.listeners;
                synchronized (list) {
                    for (PrivacyListListener listener : PrivacyListManager.this.listeners) {
                        for (Map.Entry<String, List<PrivacyItem>> entry : privacy.getItemLists().entrySet()) {
                            String listName = entry.getKey();
                            List<PrivacyItem> items = entry.getValue();
                            if (items.isEmpty()) {
                                listener.updatedPrivacyList(listName);
                                continue;
                            }
                            listener.setPrivacyList(listName, items);
                        }
                    }
                }
                IQ iq = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return "";
                    }
                };
                iq.setType(IQ.Type.RESULT);
                iq.setFrom(packet.getFrom());
                iq.setPacketID(packet.getPacketID());
                PrivacyListManager.this.connection.sendPacket(iq);
            }
        }, this.packetFilter);
    }

    public static PrivacyListManager getInstanceFor(Connection connection) {
        return instances.get(connection);
    }

    private Privacy getRequest(Privacy requestPrivacy) throws XMPPException {
        requestPrivacy.setType(IQ.Type.GET);
        requestPrivacy.setFrom(this.getUser());
        PacketIDFilter responseFilter = new PacketIDFilter(requestPrivacy.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(requestPrivacy);
        Privacy privacyAnswer = (Privacy)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (privacyAnswer == null) {
            throw new XMPPException("No response from server.");
        }
        if (privacyAnswer.getError() != null) {
            throw new XMPPException(privacyAnswer.getError());
        }
        return privacyAnswer;
    }

    private Packet setRequest(Privacy requestPrivacy) throws XMPPException {
        requestPrivacy.setType(IQ.Type.SET);
        requestPrivacy.setFrom(this.getUser());
        PacketIDFilter responseFilter = new PacketIDFilter(requestPrivacy.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(requestPrivacy);
        Packet privacyAnswer = response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (privacyAnswer == null) {
            throw new XMPPException("No response from server.");
        }
        if (privacyAnswer.getError() != null) {
            throw new XMPPException(privacyAnswer.getError());
        }
        return privacyAnswer;
    }

    private Privacy getPrivacyWithListNames() throws XMPPException {
        Privacy request = new Privacy();
        return this.getRequest(request);
    }

    public PrivacyList getActiveList() throws XMPPException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        String listName = privacyAnswer.getActiveName();
        boolean isDefaultAndActive = privacyAnswer.getActiveName() != null && privacyAnswer.getDefaultName() != null && privacyAnswer.getActiveName().equals(privacyAnswer.getDefaultName());
        return new PrivacyList(true, isDefaultAndActive, listName, this.getPrivacyListItems(listName));
    }

    public PrivacyList getDefaultList() throws XMPPException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        String listName = privacyAnswer.getDefaultName();
        boolean isDefaultAndActive = privacyAnswer.getActiveName() != null && privacyAnswer.getDefaultName() != null && privacyAnswer.getActiveName().equals(privacyAnswer.getDefaultName());
        return new PrivacyList(isDefaultAndActive, true, listName, this.getPrivacyListItems(listName));
    }

    private List<PrivacyItem> getPrivacyListItems(String listName) throws XMPPException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, new ArrayList<PrivacyItem>());
        Privacy privacyAnswer = this.getRequest(request);
        return privacyAnswer.getPrivacyList(listName);
    }

    public PrivacyList getPrivacyList(String listName) throws XMPPException {
        return new PrivacyList(false, false, listName, this.getPrivacyListItems(listName));
    }

    public PrivacyList[] getPrivacyLists() throws XMPPException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        Set<String> names = privacyAnswer.getPrivacyListNames();
        PrivacyList[] lists = new PrivacyList[names.size()];
        int index = 0;
        for (String listName : names) {
            boolean isActiveList = listName.equals(privacyAnswer.getActiveName());
            boolean isDefaultList = listName.equals(privacyAnswer.getDefaultName());
            lists[index] = new PrivacyList(isActiveList, isDefaultList, listName, this.getPrivacyListItems(listName));
            ++index;
        }
        return lists;
    }

    public void setActiveListName(String listName) throws XMPPException {
        Privacy request = new Privacy();
        request.setActiveName(listName);
        this.setRequest(request);
    }

    public void declineActiveList() throws XMPPException {
        Privacy request = new Privacy();
        request.setDeclineActiveList(true);
        this.setRequest(request);
    }

    public void setDefaultListName(String listName) throws XMPPException {
        Privacy request = new Privacy();
        request.setDefaultName(listName);
        this.setRequest(request);
    }

    public void declineDefaultList() throws XMPPException {
        Privacy request = new Privacy();
        request.setDeclineDefaultList(true);
        this.setRequest(request);
    }

    public void createPrivacyList(String listName, List<PrivacyItem> privacyItems) throws XMPPException {
        this.updatePrivacyList(listName, privacyItems);
    }

    public void updatePrivacyList(String listName, List<PrivacyItem> privacyItems) throws XMPPException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, privacyItems);
        this.setRequest(request);
    }

    public void deletePrivacyList(String listName) throws XMPPException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, new ArrayList<PrivacyItem>());
        this.setRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PrivacyListListener listener) {
        List<PrivacyListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new PrivacyListManager(connection);
            }
        });
    }
}

