/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.xmpp.jnodes.smack.TrackerEntry;

public class JingleTrackerIQ
extends IQ {
    public static final String NAME = "services";
    public static final String NAMESPACE = "http://jabber.org/protocol/jinglenodes";
    private final ConcurrentHashMap<String, TrackerEntry> entries = new ConcurrentHashMap();

    public JingleTrackerIQ() {
        this.setType(IQ.Type.GET);
        this.setPacketID(IQ.nextID());
    }

    public boolean isRequest() {
        return IQ.Type.GET.equals(this.getType());
    }

    public void addEntry(TrackerEntry entry) {
        this.entries.put(entry.getJid(), entry);
    }

    public void removeEntry(TrackerEntry entry) {
        this.entries.remove(entry.getJid());
    }

    public String getChildElementXML() {
        StringBuilder str = new StringBuilder();
        str.append("<").append(NAME).append(" xmlns='").append(NAMESPACE).append("'>");
        for (TrackerEntry entry : this.entries.values()) {
            str.append("<").append(entry.getType().toString());
            str.append(" policy='").append(entry.getPolicy().toString()).append("'");
            str.append(" address='").append(entry.getJid()).append("'");
            str.append(" protocol='").append(entry.getProtocol()).append("'");
            if (entry.isVerified()) {
                str.append(" verified='").append(entry.isVerified()).append("'");
            }
            str.append("/>");
        }
        str.append("</").append(NAME).append(">");
        return str.toString();
    }

    public Collection<TrackerEntry> getEntries() {
        return this.entries.values();
    }
}

