/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

class InitiationListener
implements PacketListener {
    private final InBandBytestreamManager manager;
    private final PacketFilter initFilter = new AndFilter(new PacketTypeFilter(Open.class), new IQTypeFilter(IQ.Type.SET));
    private final ExecutorService initiationListenerExecutor;

    protected InitiationListener(InBandBytestreamManager manager) {
        this.manager = manager;
        this.initiationListenerExecutor = Executors.newCachedThreadPool();
    }

    @Override
    public void processPacket(final Packet packet) {
        this.initiationListenerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                InitiationListener.this.processRequest(packet);
            }
        });
    }

    private void processRequest(Packet packet) {
        Open ibbRequest = (Open)packet;
        if (ibbRequest.getBlockSize() > this.manager.getMaximumBlockSize()) {
            this.manager.replyResourceConstraintPacket(ibbRequest);
            return;
        }
        if (this.manager.getIgnoredBytestreamRequests().remove(ibbRequest.getSessionID())) {
            return;
        }
        InBandBytestreamRequest request = new InBandBytestreamRequest(this.manager, ibbRequest);
        BytestreamListener userListener = this.manager.getUserListener(ibbRequest.getFrom());
        if (userListener != null) {
            userListener.incomingBytestreamRequest(request);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener listener : this.manager.getAllRequestListeners()) {
                listener.incomingBytestreamRequest(request);
            }
        } else {
            this.manager.replyRejectPacket(ibbRequest);
        }
    }

    protected PacketFilter getFilter() {
        return this.initFilter;
    }

    protected void shutdown() {
        this.initiationListenerExecutor.shutdownNow();
    }
}

