/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.MessageEventNotificationListener;
import org.jivesoftware.smackx.MessageEventRequestListener;
import org.jivesoftware.smackx.packet.MessageEvent;

public class MessageEventManager {
    private List<MessageEventNotificationListener> messageEventNotificationListeners = new ArrayList<MessageEventNotificationListener>();
    private List<MessageEventRequestListener> messageEventRequestListeners = new ArrayList<MessageEventRequestListener>();
    private Connection con;
    private PacketFilter packetFilter = new PacketExtensionFilter("x", "jabber:x:event");
    private PacketListener packetListener;

    public MessageEventManager(Connection con) {
        this.con = con;
        this.init();
    }

    public static void addNotificationsRequests(Message message, boolean offline, boolean delivered, boolean displayed, boolean composing) {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setOffline(offline);
        messageEvent.setDelivered(delivered);
        messageEvent.setDisplayed(displayed);
        messageEvent.setComposing(composing);
        message.addExtension(messageEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        List<MessageEventRequestListener> list = this.messageEventRequestListeners;
        synchronized (list) {
            if (!this.messageEventRequestListeners.contains(messageEventRequestListener)) {
                this.messageEventRequestListeners.add(messageEventRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        List<MessageEventRequestListener> list = this.messageEventRequestListeners;
        synchronized (list) {
            this.messageEventRequestListeners.remove(messageEventRequestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        List<MessageEventNotificationListener> list = this.messageEventNotificationListeners;
        synchronized (list) {
            if (!this.messageEventNotificationListeners.contains(messageEventNotificationListener)) {
                this.messageEventNotificationListeners.add(messageEventNotificationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        List<MessageEventNotificationListener> list = this.messageEventNotificationListeners;
        synchronized (list) {
            this.messageEventNotificationListeners.remove(messageEventNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEventRequestListeners(String from, String packetID, String methodName) {
        MessageEventRequestListener[] listeners = null;
        List<MessageEventRequestListener> list = this.messageEventRequestListeners;
        synchronized (list) {
            listeners = new MessageEventRequestListener[this.messageEventRequestListeners.size()];
            this.messageEventRequestListeners.toArray(listeners);
        }
        try {
            Method method = MessageEventRequestListener.class.getDeclaredMethod(methodName, String.class, String.class, MessageEventManager.class);
            for (int i = 0; i < listeners.length; ++i) {
                method.invoke((Object)listeners[i], from, packetID, this);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEventNotificationListeners(String from, String packetID, String methodName) {
        MessageEventNotificationListener[] listeners = null;
        List<MessageEventNotificationListener> list = this.messageEventNotificationListeners;
        synchronized (list) {
            listeners = new MessageEventNotificationListener[this.messageEventNotificationListeners.size()];
            this.messageEventNotificationListeners.toArray(listeners);
        }
        try {
            Method method = MessageEventNotificationListener.class.getDeclaredMethod(methodName, String.class, String.class);
            for (int i = 0; i < listeners.length; ++i) {
                method.invoke((Object)listeners[i], from, packetID);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                MessageEvent messageEvent = (MessageEvent)message.getExtension("x", "jabber:x:event");
                if (messageEvent.isMessageEventRequest()) {
                    Iterator<String> it = messageEvent.getEventTypes();
                    while (it.hasNext()) {
                        MessageEventManager.this.fireMessageEventRequestListeners(message.getFrom(), message.getPacketID(), it.next().concat("NotificationRequested"));
                    }
                } else {
                    Iterator<String> it = messageEvent.getEventTypes();
                    while (it.hasNext()) {
                        MessageEventManager.this.fireMessageEventNotificationListeners(message.getFrom(), messageEvent.getPacketID(), it.next().concat("Notification"));
                    }
                }
            }
        };
        this.con.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void sendDeliveredNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDelivered(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void sendDisplayedNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDisplayed(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void sendComposingNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setComposing(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void sendCancelledNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setCancelled(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void destroy() {
        if (this.con != null) {
            this.con.removePacketListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

