/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.eventservice.impl.EventPacket;
import com.hazelcast.spi.impl.eventservice.impl.EventPacketProcessor;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import java.io.IOException;

public class SendEventOperation
extends AbstractOperation {
    private EventPacket eventPacket;
    private int orderKey;

    public SendEventOperation() {
    }

    public SendEventOperation(EventPacket eventPacket, int orderKey) {
        this.eventPacket = eventPacket;
        this.orderKey = orderKey;
    }

    @Override
    public void run() throws Exception {
        EventServiceImpl eventService = (EventServiceImpl)this.getNodeEngine().getEventService();
        eventService.executeEventCallback(new EventPacketProcessor(eventService, this.eventPacket, this.orderKey));
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.eventPacket.writeData(out);
        out.writeInt(this.orderKey);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.eventPacket = new EventPacket();
        this.eventPacket.readData(in);
        this.orderKey = in.readInt();
    }
}

