/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapEntrySet;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClientReplicatedMapPutAllRequest
extends AbstractReplicatedMapClientRequest {
    private ReplicatedMapEntrySet entrySet;

    ClientReplicatedMapPutAllRequest() {
        super(null);
    }

    public ClientReplicatedMapPutAllRequest(String mapName, ReplicatedMapEntrySet entrySet) {
        super(mapName);
        this.entrySet = entrySet;
    }

    public Object call() throws Exception {
        ReplicatedRecordStore recordStore = this.getReplicatedRecordStore();
        Set entries = this.entrySet.getEntrySet();
        for (Map.Entry entry : entries) {
            recordStore.put(entry.getKey(), entry.getValue());
        }
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        this.entrySet.writePortable(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.entrySet = new ReplicatedMapEntrySet();
        this.entrySet.readPortable(reader);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "put");
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        Set set = this.entrySet.getEntrySet();
        HashMap map = new HashMap();
        for (Map.Entry entry : set) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new Object[]{map};
    }
}

