/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.ValueCollectionFactory;
import com.hazelcast.multimap.impl.client.MultiMapKeyBasedRequest;
import com.hazelcast.multimap.impl.operations.GetAllOperation;
import com.hazelcast.multimap.impl.operations.MultiMapResponse;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PortableCollection;
import java.io.IOException;
import java.util.Collection;

public class GetAllRequest
extends MultiMapKeyBasedRequest
implements RetryableRequest {
    private long threadId;

    public GetAllRequest() {
    }

    public GetAllRequest(String name, Data key) {
        super(name, key);
    }

    public GetAllRequest(String name, Data key, long threadId) {
        super(name, key);
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        GetAllOperation operation = new GetAllOperation(this.name, this.key);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof MultiMapResponse) {
            Collection responseCollection = ((MultiMapResponse)response).getCollection();
            if (responseCollection == null) {
                return new PortableCollection();
            }
            Collection<Data> collection = ValueCollectionFactory.createCollection(responseCollection);
            for (MultiMapRecord record : responseCollection) {
                collection.add((Data)this.serializationService.toData(record.getObject()));
            }
            return new PortableCollection(collection);
        }
        return super.filter(response);
    }

    @Override
    public String getMethodName() {
        return "get";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("threadId", this.threadId);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("threadId");
        super.read(reader);
    }
}

