/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.MultiPartitionClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MultipleEntryOperationFactory;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapExecuteOnKeysRequest
extends MultiPartitionClientRequest
implements Portable,
SecureRequest {
    private String name;
    private EntryProcessor processor;
    private Set<Data> keys;

    public MapExecuteOnKeysRequest() {
    }

    public MapExecuteOnKeysRequest(String name, EntryProcessor processor, Set<Data> keys) {
        this.name = name;
        this.processor = processor;
        this.keys = keys;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultipleEntryOperationFactory(this.name, this.keys, this.processor);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapEntrySet result = new MapEntrySet();
        MapService mapService = (MapService)this.getService();
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntrySet entrySet = (MapEntrySet)mapService.getMapServiceContext().toObject(o);
            Set<Map.Entry<Data, Data>> entries = entrySet.getEntrySet();
            for (Map.Entry<Data, Data> entry : entries) {
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public Collection<Integer> getPartitions() {
        InternalPartitionService partitionService = this.getClientEngine().getPartitionService();
        int partitions = partitionService.getPartitionCount();
        int capacity = Math.min(partitions, this.keys.size());
        HashSet<Integer> partitionIds = new HashSet<Integer>(capacity);
        Iterator<Data> iterator = this.keys.iterator();
        while (iterator.hasNext() && partitionIds.size() < partitions) {
            Data key = iterator.next();
            partitionIds.add(partitionService.getPartitionId(key));
        }
        return partitionIds;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 45;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("size", this.keys.size());
        ObjectDataOutput output = writer.getRawDataOutput();
        for (Data key : this.keys) {
            output.writeData(key);
        }
        output.writeObject(this.processor);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        int size = reader.readInt("size");
        this.keys = new HashSet<Data>();
        ObjectDataInput input = reader.getRawDataInput();
        for (int i = 0; i < size; ++i) {
            Data key = input.readData();
            this.keys.add(key);
        }
        this.processor = (EntryProcessor)input.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "executeOnKeys";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.processor};
    }
}

