/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapContextQuerySupport;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.QueryResultSizeLimiter;
import com.hazelcast.map.impl.operation.QueryOperation;
import com.hazelcast.map.impl.operation.QueryPartitionOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.SortingUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class BasicMapContextQuerySupport
implements MapContextQuerySupport {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;
    private final ILogger logger;
    private final QueryResultSizeLimiter queryResultSizeLimiter;

    public BasicMapContextQuerySupport(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
    }

    @Override
    public Collection<QueryableEntry> queryOnPartition(String mapName, Predicate predicate, int partitionId) {
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        PagingPredicate pagingPredicate = predicate instanceof PagingPredicate ? (PagingPredicate)predicate : null;
        LinkedList<QueryableEntry> resultList = new LinkedList<QueryableEntry>();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(partitionId);
        Iterator<Record> iterator = container.getRecordStore(mapName).loadAwareIterator(this.getNow(), false);
        Map.Entry<Integer, Map.Entry> nearestAnchorEntry = PagingPredicateAccessor.getNearestAnchorEntry(pagingPredicate);
        while (iterator.hasNext()) {
            QueryEntry queryEntry;
            Record record = iterator.next();
            Data key = record.getKey();
            Object value = this.getValueOrCachedValue(record);
            if (value == null || !predicate.apply(queryEntry = new QueryEntry(serializationService, key, key, value)) || !SortingUtil.compareAnchor(pagingPredicate, queryEntry, nearestAnchorEntry)) continue;
            resultList.add(queryEntry);
        }
        return SortingUtil.getSortedSubList(resultList, pagingPredicate, nearestAnchorEntry);
    }

    private Object getValueOrCachedValue(Record record) {
        Object value = record.getCachedValue();
        if (value == Record.NOT_CACHED) {
            value = record.getValue();
        } else if (value == null && (value = record.getValue()) instanceof Data && !((Data)value).isPortable()) {
            value = this.nodeEngine.getSerializationService().toObject(value);
            record.setCachedValue(value);
        }
        return value;
    }

    @Override
    public Set queryLocalMember(String mapName, Predicate predicate, IterationType iterationType, boolean dataResult) {
        this.checkIfNotPagingPredicate(predicate);
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        QueryResultSet result = new QueryResultSet(serializationService, iterationType, dataResult);
        List<Integer> partitionIds = this.getLocalPartitionIds();
        try {
            Future<QueryResult> future = this.queryOnLocalMember(mapName, predicate);
            List<Future<QueryResult>> futures = Collections.singletonList(future);
            this.addResultsOfPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                return result;
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            List<Future<QueryResult>> futures = this.queryOnPartitions(mapName, predicate, partitionIds);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    @Override
    public Set queryLocalMemberWithPagingPredicate(String mapName, PagingPredicate pagingPredicate, IterationType iterationType) {
        pagingPredicate.setIterationType(iterationType);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>();
        List<Integer> partitionIds = this.getLocalPartitionIds();
        try {
            Future<QueryResult> future = this.queryOnLocalMember(mapName, pagingPredicate);
            List<Future<QueryResult>> futures = Collections.singletonList(future);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
            if (partitionIds.isEmpty()) {
                return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, iterationType);
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            List<Future<QueryResult>> futures = this.queryOnPartitions(mapName, pagingPredicate, partitionIds);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, iterationType);
    }

    @Override
    public Set queryWithPagingPredicate(String mapName, PagingPredicate pagingPredicate, IterationType iterationType) {
        List<Future<QueryResult>> futures;
        pagingPredicate.setIterationType(iterationType);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>();
        Set<Integer> partitionIds = this.getAllPartitionIds();
        try {
            futures = this.queryOnMembers(mapName, pagingPredicate);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
            if (partitionIds.isEmpty()) {
                return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, iterationType);
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            futures = this.queryOnPartitions(mapName, pagingPredicate, partitionIds);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, iterationType);
    }

    @Override
    public Set query(String mapName, Predicate predicate, IterationType iterationType, boolean dataResult) {
        List<Future<QueryResult>> futures;
        this.checkIfNotPagingPredicate(predicate);
        if (predicate == TruePredicate.INSTANCE) {
            this.queryResultSizeLimiter.checkMaxResultLimitOnLocalPartitions(mapName);
        }
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        QueryResultSet result = new QueryResultSet(serializationService, iterationType, dataResult);
        Set<Integer> partitionIds = this.getAllPartitionIds();
        try {
            futures = this.queryOnMembers(mapName, predicate);
            this.addResultsOfPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                return result;
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            futures = this.queryOnPartitions(mapName, predicate, partitionIds);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    @Override
    public QueryResult newQueryResult(int numberOfPartitions) {
        return new QueryResult(this.queryResultSizeLimiter.getNodeResultLimit(numberOfPartitions));
    }

    private void checkIfNotPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("Predicate should not be a type of paging predicate");
        }
    }

    private Future<QueryResult> queryOnLocalMember(String mapName, Predicate predicate) {
        QueryOperation operation = new QueryOperation(mapName, predicate);
        return this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:mapService", operation, this.nodeEngine.getThisAddress());
    }

    private List<Future<QueryResult>> queryOnMembers(String mapName, Predicate predicate) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future<QueryResult>> futures = new ArrayList<Future<QueryResult>>(members.size());
        for (MemberImpl member : members) {
            QueryOperation operation = new QueryOperation(mapName, predicate);
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:mapService", operation, member.getAddress());
            futures.add(future);
        }
        return futures;
    }

    private List<Future<QueryResult>> queryOnPartitions(String mapName, Predicate predicate, Collection<Integer> partitionIds) {
        if (partitionIds == null || partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        OperationService operationService = this.nodeEngine.getOperationService();
        ArrayList<Future<QueryResult>> futures = new ArrayList<Future<QueryResult>>(partitionIds.size());
        for (Integer partitionId : partitionIds) {
            QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(mapName, predicate);
            queryPartitionOperation.setPartitionId(partitionId);
            try {
                InternalCompletableFuture future = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, partitionId);
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return futures;
    }

    private void addResultsOfPagingPredicate(List<Future<QueryResult>> futures, Collection result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future<QueryResult> future : futures) {
            Collection<Integer> tmpPartitionIds;
            QueryResult queryResult = future.get();
            if (queryResult == null || (tmpPartitionIds = queryResult.getPartitionIds()) == null) continue;
            partitionIds.removeAll(tmpPartitionIds);
            for (QueryResultEntry queryResultEntry : queryResult.getResult()) {
                Object key = this.toObject(queryResultEntry.getKeyData());
                Object value = this.toObject(queryResultEntry.getValueData());
                result.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
            }
        }
    }

    private void addResultsOfPredicate(List<Future<QueryResult>> futures, Set result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future<QueryResult> future : futures) {
            Collection<Integer> queriedPartitionIds;
            QueryResult queryResult = future.get();
            if (queryResult == null || (queriedPartitionIds = queryResult.getPartitionIds()) == null) continue;
            partitionIds.removeAll(queriedPartitionIds);
            result.addAll(queryResult.getResult());
        }
    }

    private Object toObject(Object obj) {
        return this.nodeEngine.getSerializationService().toObject(obj);
    }

    private List<Integer> getLocalPartitionIds() {
        return this.nodeEngine.getPartitionService().getMemberPartitions(this.nodeEngine.getThisAddress());
    }

    private Set<Integer> getAllPartitionIds() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        return this.createSetWithPopulatedPartitionIds(partitionCount);
    }

    private Set<Integer> createSetWithPopulatedPartitionIds(int partitionCount) {
        HashSet<Integer> partitionIds = new HashSet<Integer>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            partitionIds.add(i);
        }
        return partitionIds;
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }
}

