/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitors;

import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.util.concurrent.TimeUnit;

public class PerformanceMonitor
extends Thread {
    private final ILogger logger;
    private final Node node;
    private final int delaySeconds;
    private final InternalOperationService operationService;
    private final ConnectionManager connectionManager;

    public PerformanceMonitor(HazelcastInstanceImpl hazelcastInstance, int delaySeconds) {
        super(hazelcastInstance.node.getHazelcastThreadGroup().getInternalThreadGroup(), hazelcastInstance.node.getHazelcastThreadGroup().getThreadNamePrefix("PerformanceMonitor"));
        this.setDaemon(true);
        this.delaySeconds = delaySeconds;
        this.node = hazelcastInstance.node;
        this.logger = this.node.getLogger(PerformanceMonitor.class.getName());
        this.operationService = this.node.nodeEngine.getOperationService();
        this.connectionManager = this.node.connectionManager;
    }

    @Override
    public void run() {
        StringBuffer sb = new StringBuffer();
        while (this.node.isActive()) {
            sb.append("\n");
            sb.append("ConnectionManager metrics\n");
            this.connectionManager.dumpPerformanceMetrics(sb);
            sb.append("OperationService metrics\n");
            this.operationService.dumpPerformanceMetrics(sb);
            this.logger.info(sb.toString());
            sb.setLength(0);
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.delaySeconds));
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

