/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.concurrent.lock.client.AwaitRequest;
import com.hazelcast.concurrent.lock.client.BeforeAwaitRequest;
import com.hazelcast.concurrent.lock.client.GetLockCountRequest;
import com.hazelcast.concurrent.lock.client.GetRemainingLeaseRequest;
import com.hazelcast.concurrent.lock.client.IsLockedRequest;
import com.hazelcast.concurrent.lock.client.LockRequest;
import com.hazelcast.concurrent.lock.client.SignalRequest;
import com.hazelcast.concurrent.lock.client.UnlockRequest;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableHook;
import java.util.Collection;

public class LockPortableHook
implements PortableHook {
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.portable.lock", -15);
    public static final int LOCK = 1;
    public static final int UNLOCK = 2;
    public static final int IS_LOCKED = 3;
    public static final int GET_LOCK_COUNT = 5;
    public static final int GET_REMAINING_LEASE = 6;
    public static final int CONDITION_BEFORE_AWAIT = 7;
    public static final int CONDITION_AWAIT = 8;
    public static final int CONDITION_SIGNAL = 9;

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public PortableFactory createFactory() {
        return new PortableFactory(){

            @Override
            public Portable create(int classId) {
                switch (classId) {
                    case 1: {
                        return new LockRequest();
                    }
                    case 2: {
                        return new UnlockRequest();
                    }
                    case 3: {
                        return new IsLockedRequest();
                    }
                    case 5: {
                        return new GetLockCountRequest();
                    }
                    case 6: {
                        return new GetRemainingLeaseRequest();
                    }
                    case 7: {
                        return new BeforeAwaitRequest();
                    }
                    case 8: {
                        return new AwaitRequest();
                    }
                    case 9: {
                        return new SignalRequest();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Collection<ClassDefinition> getBuiltinDefinitions() {
        return null;
    }
}

