/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.countdownlatch.client.CountDownLatchPortableHook;
import com.hazelcast.concurrent.countdownlatch.operations.SetCountOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public final class SetCountRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private String name;
    private int count;

    public SetCountRequest() {
    }

    public SetCountRequest(String name, int count) {
        this.name = name;
        this.count = count;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        return new SetCountOperation(this.name, this.count);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
        writer.writeInt("count", this.count);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.count = reader.readInt("count");
    }

    @Override
    public Permission getRequiredPermission() {
        return new CountDownLatchPermission(this.name, "modify");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "trySetCount";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.count};
    }
}

