/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.collection.impl.queue.QueuePortableHook;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import java.io.IOException;
import java.security.Permission;

public class TxnSizeRequest
extends BaseTransactionRequest
implements Portable,
SecureRequest {
    String name;

    public TxnSizeRequest() {
    }

    public TxnSizeRequest(String name) {
        this.name = name;
    }

    @Override
    public Object innerCall() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext context = endpoint.getTransactionContext(this.txnId);
        TransactionalQueue queue = context.getQueue(this.name);
        return queue.size();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "read");
    }
}

