/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue;

import com.hazelcast.collection.impl.txnqueue.TransactionLogKey;
import com.hazelcast.collection.impl.txnqueue.operations.TxnPollOperation;
import com.hazelcast.collection.impl.txnqueue.operations.TxnPrepareOperation;
import com.hazelcast.collection.impl.txnqueue.operations.TxnRollbackOperation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.concurrent.Future;

public class QueueTransactionLog
implements KeyAwareTransactionLog {
    private long itemId;
    private String name;
    private Operation op;
    private int partitionId;
    private String transactionId;

    public QueueTransactionLog() {
    }

    public QueueTransactionLog(String transactionId, long itemId, String name, int partitionId, Operation op) {
        this.transactionId = transactionId;
        this.itemId = itemId;
        this.name = name;
        this.partitionId = partitionId;
        this.op = op;
    }

    @Override
    public Future prepare(NodeEngine nodeEngine) {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        TxnPrepareOperation operation = new TxnPrepareOperation(this.name, this.itemId, pollOperation, this.transactionId);
        try {
            return this.invoke(nodeEngine, operation);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private InternalCompletableFuture invoke(NodeEngine nodeEngine, Operation operation) {
        OperationService operationService = nodeEngine.getOperationService();
        return operationService.invokeOnPartition("hz:impl:queueService", operation, this.partitionId);
    }

    @Override
    public Future commit(NodeEngine nodeEngine) {
        try {
            OperationService operationService = nodeEngine.getOperationService();
            return operationService.invokeOnPartition("hz:impl:queueService", this.op, this.partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void commitAsync(NodeEngine nodeEngine, ExecutionCallback callback) {
        InternalOperationService operationService = (InternalOperationService)nodeEngine.getOperationService();
        operationService.asyncInvokeOnPartition("hz:impl:queueService", this.op, this.partitionId, callback);
    }

    @Override
    public Future rollback(NodeEngine nodeEngine) {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        TxnRollbackOperation operation = new TxnRollbackOperation(this.name, this.itemId, pollOperation);
        try {
            return this.invoke(nodeEngine, operation);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void rollbackAsync(NodeEngine nodeEngine, ExecutionCallback callback) {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        TxnRollbackOperation operation = new TxnRollbackOperation(this.name, this.itemId, pollOperation);
        InternalOperationService operationService = (InternalOperationService)nodeEngine.getOperationService();
        operationService.asyncInvokeOnPartition("hz:impl:queueService", operation, this.partitionId, callback);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.transactionId);
        out.writeLong(this.itemId);
        out.writeUTF(this.name);
        out.writeInt(this.partitionId);
        out.writeObject(this.op);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.transactionId = in.readUTF();
        this.itemId = in.readLong();
        this.name = in.readUTF();
        this.partitionId = in.readInt();
        this.op = (Operation)in.readObject();
    }

    @Override
    public Object getKey() {
        return new TransactionLogKey(this.itemId, this.name);
    }
}

