/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class CacheCreateConfigRequest
extends ClientRequest {
    private static final int TRY_COUNT = 100;
    private CacheConfig cacheConfig;
    private boolean createAlsoOnOthers = true;
    private boolean ignoreLocal;
    private int partitionId;

    public CacheCreateConfigRequest() {
    }

    public CacheCreateConfigRequest(CacheConfig cacheConfig, boolean createAlsoOnOthers, boolean ignoreLocal, int partitionId) {
        this.cacheConfig = cacheConfig;
        this.createAlsoOnOthers = createAlsoOnOthers;
        this.ignoreLocal = ignoreLocal;
        this.partitionId = partitionId;
    }

    @Override
    public final void process() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        Operation op = this.prepareOperation();
        op.setCallerUuid(endpoint.getUuid());
        InvocationBuilder builder = this.operationService.createInvocationBuilder(this.getServiceName(), op, this.partitionId);
        builder.setTryCount(100).setResultDeserialized(false).setCallback(new Callback<Object>(){

            @Override
            public void notify(Object object) {
                endpoint.sendResponse(object, CacheCreateConfigRequest.this.getCallId());
            }
        });
        builder.invoke();
    }

    protected Operation prepareOperation() {
        return new CacheCreateConfigOperation(this.cacheConfig, this.createAlsoOnOthers, this.ignoreLocal);
    }

    @Override
    public final int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeBoolean("o", this.createAlsoOnOthers);
        writer.writeBoolean("l", this.ignoreLocal);
        writer.writeInt("p", this.partitionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.cacheConfig);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.createAlsoOnOthers = reader.readBoolean("o");
        this.ignoreLocal = reader.readBoolean("l");
        this.partitionId = reader.readInt("p");
        ObjectDataInput in = reader.getRawDataInput();
        this.cacheConfig = (CacheConfig)in.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

