/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws CertPathValidatorException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return this.getObject(string, byArray);
    }

    private DERObject getObject(String string, byte[] byArray) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing extension " + string);
        }
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i = aSN1Sequence2.size() - 1; i >= 0; --i) {
            if (aSN1Sequence2.getObjectAt(i).equals(aSN1Sequence.getObjectAt(i))) continue;
            return false;
        }
        return true;
    }

    private void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set intersectDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet.add(aSN1Sequence2);
        }
        return hashSet;
    }

    private Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private Set intersectEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Set unionEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string3);
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set intersectIP(Set set, byte[] byArray) {
        return set;
    }

    private Set unionIP(Set set, byte[] byArray) {
        return set;
    }

    private void checkPermittedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            for (int i = 0; i < listArray.length; ++i) {
                listArray[i] = new ArrayList();
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
            }
        }
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getSubjectDN()).equals(x509Certificate.getIssuerDN());
    }

    private boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private boolean processCertD1i(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        for (int i = 0; i < list.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!set2.contains(dERObjectIdentifier.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n].add(pKIXPolicyNode2);
            return true;
        }
        return false;
    }

    private void processCertD1ii(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        for (int i = 0; i < list.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n].add(pKIXPolicyNode2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator<PKIXCertPathChecker> iterator;
        int n;
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Set<String> set;
        Object object5;
        Iterator iterator2;
        PublicKey publicKey;
        X500Principal x500Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        Set<String> set2 = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), certPath, list.size() - 1, pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found.", null, certPath, -1);
        }
        int n3 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        listArray[0].add(pKIXPolicyNode);
        Set set3 = new HashSet();
        Set set4 = new HashSet();
        Set set5 = new HashSet();
        Set set6 = new HashSet();
        Set set7 = new HashSet();
        Set set8 = new HashSet();
        HashSet hashSet4 = null;
        int n4 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = this.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n7 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        List<PKIXCertPathChecker> list2 = pKIXParameters.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator3 = list2.iterator();
        while (iterator3.hasNext()) {
            iterator3.next().init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            try {
                x509Certificate2.verify(publicKey, "BC");
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)generalSecurityException, certPath, n3);
            }
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                throw new CertPathValidatorException("Could not validate certificate: " + certificateExpiredException.getMessage(), (Throwable)certificateExpiredException, certPath, n3);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertPathValidatorException("Could not validate certificate: " + certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException, certPath, n3);
            }
            if (pKIXParameters.isRevocationEnabled()) {
                boolean bl = false;
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                try {
                    x509CRLSelector.addIssuerName(this.getEncodedIssuerPrincipal(x509Certificate2).getEncoded());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("Cannot extract issuer from certificate: " + iOException);
                }
                x509CRLSelector.setCertificateChecking(x509Certificate2);
                iterator2 = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
                while (iterator2.hasNext()) {
                    object5 = (X509CRL)iterator2.next();
                    if (!x509Certificate2.getNotAfter().after(((X509CRL)object5).getThisUpdate())) continue;
                    if (((X509CRL)object5).getNextUpdate() == null || date.before(((X509CRL)object5).getNextUpdate())) {
                        bl = true;
                    }
                    if (x509Certificate != null && (set = (Set<String>)x509Certificate.getKeyUsage()) != null && (((Object)set).length < 7 || set[6] == false)) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate, null, certPath, n3);
                    }
                    try {
                        ((X509CRL)object5).verify(publicKey, "BC");
                    }
                    catch (Exception exception) {
                        throw new CertPathValidatorException("can't verify CRL: " + exception);
                    }
                    object4 = ((X509CRL)object5).getRevokedCertificate(x509Certificate2.getSerialNumber());
                    if (object4 != null && !date.before(((X509CRLEntry)object4).getRevocationDate())) {
                        Object object7;
                        set = null;
                        if (((X509CRLEntry)object4).hasExtensions() && (object7 = DEREnumerated.getInstance(this.getExtensionValue((X509Extension)object4, X509Extensions.ReasonCode.getId()))) != null) {
                            set = crlReasons[((DEREnumerated)object7).getValue().intValue()];
                        }
                        object7 = "Certificate revocation after " + ((X509CRLEntry)object4).getRevocationDate();
                        if (set != null) {
                            object7 = (String)object7 + ", reason: " + (String)((Object)set);
                        }
                        throw new CertPathValidatorException((String)object7, null, certPath, n3);
                    }
                    set = this.getExtensionValue((X509Extension)object5, ISSUING_DISTRIBUTION_POINT);
                    DERObject dERObject = this.getExtensionValue((X509Extension)object5, DELTA_CRL_INDICATOR);
                    if (dERObject != null) {
                        X509CRLSelector object6 = new X509CRLSelector();
                        try {
                            object6.addIssuerName(this.getIssuerPrincipal((X509CRL)object5).getEncoded());
                        }
                        catch (IOException dERObjectIdentifier4) {
                            throw new CertPathValidatorException("can't extract issuer from certificate: " + dERObjectIdentifier4);
                        }
                        object6.setMinCRLNumber(((DERInteger)dERObject).getPositiveValue());
                        object6.setMaxCRLNumber(((DERInteger)this.getExtensionValue((X509Extension)object5, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                        boolean generalSubtree = false;
                        for (Object object32 : this.findCRLs(object6, pKIXParameters.getCertStores())) {
                            object2 = this.getExtensionValue((X509Extension)object32, ISSUING_DISTRIBUTION_POINT);
                            if (set == null) {
                                if (object2 != null) continue;
                                generalSubtree = true;
                                break;
                            }
                            if (!((DERObject)((Object)set)).equals(object2)) continue;
                            generalSubtree = true;
                            break;
                        }
                        if (!generalSubtree) {
                            throw new CertPathValidatorException("No base CRL for delta CRL");
                        }
                    }
                    if (set == null) continue;
                    IssuingDistributionPoint j = IssuingDistributionPoint.getInstance(set);
                    BasicConstraints enumeration = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS));
                    if (j.onlyContainsUserCerts() && (enumeration == null || enumeration.isCA())) {
                        throw new CertPathValidatorException("CA Cert CRL only contains user certificates");
                    }
                    if (j.onlyContainsCACerts() && (enumeration == null || !enumeration.isCA())) {
                        throw new CertPathValidatorException("End CRL only contains CA certificates");
                    }
                    if (!j.onlyContainsAttributeCerts()) continue;
                    throw new CertPathValidatorException("onlyContainsAttributeCerts boolean is asserted");
                }
                if (!bl) {
                    throw new CertPathValidatorException("no valid CRL found", null, certPath, n3);
                }
            }
            if (!this.getEncodedIssuerPrincipal(x509Certificate2).equals(x500Principal)) {
                throw new CertPathValidatorException("IssuerName(" + this.getEncodedIssuerPrincipal(x509Certificate2) + ") does not match SubjectName(" + x500Principal + ") of signing certificate", null, certPath, n3);
            }
            if (!this.isSelfIssued(x509Certificate2) || n8 >= n2) {
                iterator2 = this.getSubjectPrincipal(x509Certificate2);
                object4 = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)((Object)iterator2)).getEncoded()));
                try {
                    object5 = (ASN1Sequence)((ASN1InputStream)object4).readObject();
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                }
                this.checkPermittedDN(set3, (ASN1Sequence)object5);
                this.checkExcludedDN(set6, (ASN1Sequence)object5);
                set = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                if (set != null) {
                    block48: for (int i = 0; i < ((ASN1Sequence)((Object)set)).size(); ++i) {
                        ASN1TaggedObject list4 = (ASN1TaggedObject)((ASN1Sequence)((Object)set)).getObjectAt(i);
                        switch (list4.getTagNo()) {
                            case 1: {
                                String bigInteger = DERIA5String.getInstance(list4, true).getString();
                                this.checkPermittedEmail(set4, bigInteger);
                                this.checkExcludedEmail(set7, bigInteger);
                                continue block48;
                            }
                            case 4: {
                                object = ASN1Sequence.getInstance(list4, true);
                                this.checkPermittedDN(set3, (ASN1Sequence)object);
                                this.checkExcludedDN(set6, (ASN1Sequence)object);
                                continue block48;
                            }
                            case 7: {
                                object32 = ASN1OctetString.getInstance(list4, true).getOctets();
                                this.checkPermittedIP(set5, (byte[])object32);
                                this.checkExcludedIP(set8, (byte[])object32);
                            }
                        }
                    }
                }
            }
            if ((iterator2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                object4 = ((ASN1Sequence)((Object)iterator2)).getObjects();
                object5 = new HashSet();
                while (object4.hasMoreElements()) {
                    Set dERObjectIdentifier3;
                    boolean blArray;
                    set = PolicyInformation.getInstance(object4.nextElement());
                    DERObjectIdentifier dERObjectIdentifier2 = ((PolicyInformation)((Object)set)).getPolicyIdentifier();
                    object5.add(dERObjectIdentifier2.getId());
                    if (ANY_POLICY.equals(dERObjectIdentifier2.getId()) || (blArray = this.processCertD1i(n8, listArray, dERObjectIdentifier2, dERObjectIdentifier3 = this.getQualifierSet(((PolicyInformation)((Object)set)).getPolicyQualifiers())))) continue;
                    this.processCertD1ii(n8, listArray, dERObjectIdentifier2, dERObjectIdentifier3);
                }
                if (hashSet4 == null || hashSet4.contains(ANY_POLICY)) {
                    hashSet4 = object5;
                } else {
                    set = hashSet4.iterator();
                    HashSet hashSet5 = new HashSet();
                    while (set.hasNext()) {
                        Object enumeration = set.next();
                        if (!object5.contains(enumeration)) continue;
                        hashSet5.add(enumeration);
                    }
                    hashSet4 = hashSet5;
                }
                if (n5 > 0 || n8 < n2 && this.isSelfIssued(x509Certificate2)) {
                    object4 = ((ASN1Sequence)((Object)iterator2)).getObjects();
                    while (object4.hasMoreElements()) {
                        set = PolicyInformation.getInstance(object4.nextElement());
                        if (!ANY_POLICY.equals(((PolicyInformation)((Object)set)).getPolicyIdentifier().getId())) continue;
                        Set set9 = this.getQualifierSet(((PolicyInformation)((Object)set)).getPolicyQualifiers());
                        List aSN1Sequence = listArray[n8 - 1];
                        for (int j = 0; j < aSN1Sequence.size(); ++j) {
                            object = (PKIXPolicyNode)aSN1Sequence.get(j);
                            object32 = ((PKIXPolicyNode)object).getExpectedPolicies().iterator();
                            while (object32.hasNext()) {
                                Object object6;
                                String string;
                                object2 = object32.next();
                                if (object2 instanceof String) {
                                    string = (String)object2;
                                } else {
                                    if (!(object2 instanceof DERObjectIdentifier)) continue;
                                    string = ((DERObjectIdentifier)object2).getId();
                                }
                                boolean bl = false;
                                Iterator iterator4 = ((PKIXPolicyNode)object).getChildren();
                                while (iterator4.hasNext()) {
                                    object6 = (PKIXPolicyNode)iterator4.next();
                                    if (!string.equals(((PKIXPolicyNode)object6).getValidPolicy())) continue;
                                    bl = true;
                                }
                                if (bl) continue;
                                object6 = new HashSet();
                                object6.add(string);
                                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n8, (Set)object6, (PolicyNode)object, set9, string, false);
                                ((PKIXPolicyNode)object).addChild(pKIXPolicyNode2);
                                listArray[n8].add(pKIXPolicyNode2);
                            }
                        }
                    }
                }
                for (int i = n8 - 1; i >= 0; --i) {
                    PKIXPolicyNode string;
                    void n10;
                    List list3 = listArray[i];
                    boolean aSN1TaggedObject = false;
                    while (n10 < list3.size() && ((string = (PKIXPolicyNode)list3.get((int)n10)).hasChildren() || (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, string)) != null)) {
                        ++n10;
                    }
                }
                set = x509Certificate2.getCriticalExtensionOIDs();
                if (set != null) {
                    boolean bl = set.contains(CERTIFICATE_POLICIES);
                    List basicConstraints = listArray[n8];
                    for (int list5 = 0; list5 < basicConstraints.size(); ++list5) {
                        object = (PKIXPolicyNode)basicConstraints.get(list5);
                        ((PKIXPolicyNode)object).setCritical(bl);
                    }
                }
            }
            if (iterator2 == null) {
                pKIXPolicyNode = null;
            }
            if (n4 <= 0 && pKIXPolicyNode == null) {
                throw new CertPathValidatorException("No valid policy tree found when one expected.");
            }
            if (n8 != n2) {
                boolean[] blArray;
                int n9;
                BigInteger bigInteger;
                BasicConstraints i;
                int pKIXPolicyNode5;
                DERInteger dERInteger;
                if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                    throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                }
                object4 = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                if (object4 != null) {
                    object5 = (ASN1Sequence)object4;
                    for (int i2 = 0; i2 < ((ASN1Sequence)object5).size(); ++i2) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object5).getObjectAt(i2);
                        DERObjectIdentifier arrayList = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                        DERObjectIdentifier j = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                        if (ANY_POLICY.equals(arrayList.getId())) {
                            throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                        }
                        if (!ANY_POLICY.equals(j.getId())) continue;
                        throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                    }
                }
                if ((object5 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                    ASN1Sequence i3;
                    NameConstraints nameConstraints = new NameConstraints((ASN1Sequence)object5);
                    ASN1Sequence aSN1Sequence2 = nameConstraints.getPermittedSubtrees();
                    if (aSN1Sequence2 != null) {
                        Enumeration pKIXPolicyNode4 = aSN1Sequence2.getObjects();
                        while (pKIXPolicyNode4.hasMoreElements()) {
                            GeneralSubtree string = GeneralSubtree.getInstance(pKIXPolicyNode4.nextElement());
                            object = string.getBase();
                            switch (((GeneralName)object).getTagNo()) {
                                case 1: {
                                    set4 = this.intersectEmail(set4, DERIA5String.getInstance(((GeneralName)object).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    set3 = this.intersectDN(set3, (ASN1Sequence)((GeneralName)object).getName());
                                    break;
                                }
                                case 7: {
                                    set5 = this.intersectIP(set5, ASN1OctetString.getInstance(((GeneralName)object).getName()).getOctets());
                                }
                            }
                        }
                    }
                    if ((i3 = nameConstraints.getExcludedSubtrees()) != null) {
                        Enumeration arrayList = i3.getObjects();
                        while (arrayList.hasMoreElements()) {
                            object = GeneralSubtree.getInstance(arrayList.nextElement());
                            object32 = ((GeneralSubtree)object).getBase();
                            switch (((GeneralName)object32).getTagNo()) {
                                case 1: {
                                    set7 = this.unionEmail(set7, DERIA5String.getInstance(((GeneralName)object32).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    set6 = this.unionDN(set6, (ASN1Sequence)((GeneralName)object32).getName());
                                    break;
                                }
                                case 7: {
                                    set8 = this.unionIP(set8, ASN1OctetString.getInstance(((GeneralName)object32).getName()).getOctets());
                                }
                            }
                        }
                    }
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n4 != 0) {
                        --n4;
                    }
                    if (n6 != 0) {
                        --n6;
                    }
                    if (n5 != 0) {
                        --n5;
                    }
                }
                if ((set = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                    Enumeration enumeration = ((ASN1Sequence)((Object)set)).getObjects();
                    while (enumeration.hasMoreElements()) {
                        ASN1TaggedObject arrayList = (ASN1TaggedObject)enumeration.nextElement();
                        switch (arrayList.getTagNo()) {
                            case 0: {
                                n = DERInteger.getInstance(arrayList).getValue().intValue();
                                if (n >= n4) break;
                                n4 = n;
                                break;
                            }
                            case 1: {
                                n = DERInteger.getInstance(arrayList).getValue().intValue();
                                if (n >= n6) break;
                                n6 = n;
                            }
                        }
                    }
                }
                if ((dERInteger = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (pKIXPolicyNode5 = dERInteger.getValue().intValue()) < n5) {
                    n5 = pKIXPolicyNode5;
                }
                if ((i = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                    if (!i.isCA()) {
                        throw new CertPathValidatorException("Not a CA certificate");
                    }
                } else {
                    throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n7 <= 0) {
                        throw new CertPathValidatorException("Max path length not greater than zero");
                    }
                    --n7;
                }
                if (i != null && (bigInteger = i.getPathLenConstraint()) != null && (n9 = bigInteger.intValue()) < n7) {
                    n7 = n9;
                }
                if ((blArray = x509Certificate2.getKeyUsage()) != null && !blArray[5]) {
                    throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n3);
                }
                object = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                object.remove(KEY_USAGE);
                object.remove(CERTIFICATE_POLICIES);
                object.remove(POLICY_MAPPINGS);
                object.remove(INHIBIT_ANY_POLICY);
                object.remove(ISSUING_DISTRIBUTION_POINT);
                object.remove(DELTA_CRL_INDICATOR);
                object.remove(POLICY_CONSTRAINTS);
                object.remove(BASIC_CONSTRAINTS);
                object.remove(SUBJECT_ALTERNATIVE_NAME);
                object.remove(NAME_CONSTRAINTS);
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    try {
                        iterator.next().check(x509Certificate2, (Collection<String>)object);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
                    }
                }
                if (!object.isEmpty()) {
                    throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
                }
            }
            x509Certificate = x509Certificate2;
            publicKey = x509Certificate.getPublicKey();
            try {
                x500Principal = this.getSubjectPrincipal(x509Certificate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + illegalArgumentException.toString());
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
            dERObjectIdentifier = algorithmIdentifier.getObjectId();
            dEREncodable = algorithmIdentifier.getParameters();
        }
        if (!this.isSelfIssued(x509Certificate2) && n4 != 0) {
            --n4;
        }
        if ((iterator2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
            object4 = ((ASN1Sequence)((Object)iterator2)).getObjects();
            while (object4.hasMoreElements()) {
                object5 = (ASN1TaggedObject)object4.nextElement();
                switch (((ASN1TaggedObject)object5).getTagNo()) {
                    case 0: {
                        n = DERInteger.getInstance(object5).getValue().intValue();
                        if (n != 0) break;
                        n4 = 0;
                    }
                }
            }
        }
        if ((object4 = x509Certificate2.getCriticalExtensionOIDs()) != null) {
            object4 = new HashSet(object4);
            object4.remove(KEY_USAGE);
            object4.remove(CERTIFICATE_POLICIES);
            object4.remove(POLICY_MAPPINGS);
            object4.remove(INHIBIT_ANY_POLICY);
            object4.remove(ISSUING_DISTRIBUTION_POINT);
            object4.remove(DELTA_CRL_INDICATOR);
            object4.remove(POLICY_CONSTRAINTS);
            object4.remove(BASIC_CONSTRAINTS);
            object4.remove(SUBJECT_ALTERNATIVE_NAME);
            object4.remove(NAME_CONSTRAINTS);
        } else {
            object4 = new HashSet<String>();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().check(x509Certificate2, (Collection<String>)object4);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
            }
        }
        if (!object4.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
        }
        if (pKIXPolicyNode == null) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.");
            }
            object5 = null;
        } else if (this.isAnyPolicy(set2)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet4.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.");
                }
                set = new HashSet();
                for (int i = 0; i < listArray.length; ++i) {
                    ArrayList arrayList = listArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        object = (PKIXPolicyNode)arrayList.get(j);
                        if (!ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) continue;
                        object32 = ((PKIXPolicyNode)object).getChildren();
                        while (object32.hasNext()) {
                            set.add((String)object32.next());
                        }
                    }
                }
                for (PKIXPolicyNode pKIXPolicyNode3 : set) {
                    String string = pKIXPolicyNode3.getValidPolicy();
                    if (hashSet4.contains(string)) continue;
                    pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3);
                }
                if (pKIXPolicyNode != null) {
                    void var48_92;
                    int n10 = n2 - 1;
                    while (var48_92 >= 0) {
                        List list3 = listArray[var48_92];
                        for (int i = 0; i < list3.size(); ++i) {
                            object32 = (PKIXPolicyNode)list3.get(i);
                            if (((PKIXPolicyNode)object32).hasChildren()) continue;
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object32);
                        }
                        --var48_92;
                    }
                }
            }
            object5 = pKIXPolicyNode;
        } else {
            set = new HashSet();
            for (int i = 0; i < listArray.length; ++i) {
                ArrayList arrayList = listArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    object = (PKIXPolicyNode)arrayList.get(j);
                    if (!ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) continue;
                    object32 = ((PKIXPolicyNode)object).getChildren();
                    while (object32.hasNext()) {
                        object2 = (PKIXPolicyNode)object32.next();
                        if (ANY_POLICY.equals(((PKIXPolicyNode)object2).getValidPolicy())) continue;
                        set.add((String)object2);
                    }
                }
            }
            for (PKIXPolicyNode pKIXPolicyNode4 : set) {
                String string = pKIXPolicyNode4.getValidPolicy();
                if (set2.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode4);
            }
            if (pKIXPolicyNode != null) {
                void var48_96;
                int n11 = n2 - 1;
                while (var48_96 >= 0) {
                    ArrayList arrayList = listArray[var48_96];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object32 = (PKIXPolicyNode)arrayList.get(i);
                        if (((PKIXPolicyNode)object32).hasChildren()) continue;
                        pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object32);
                    }
                    --var48_96;
                }
            }
            object5 = pKIXPolicyNode;
        }
        if (n4 > 0 || object5 != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object5, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) throws CertPathValidatorException {
        HashSet<? extends CRL> hashSet = new HashSet<CRL>();
        for (CertStore certStore : list) {
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new CertPathValidatorException(certStoreException);
            }
        }
        return hashSet;
    }

    final TrustAnchor findTrustAnchor(X509Certificate x509Certificate, CertPath certPath, int n, Set set) throws CertPathValidatorException {
        Iterator iterator = set.iterator();
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(this.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException(iOException);
        }
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal = this.getEncodedIssuerPrincipal(x509Certificate);
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", exception, certPath, n);
        }
        return trustAnchor;
    }

    private X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    private X500Principal getEncodedIssuerPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getIssuerX500Principal();
    }

    private X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }
}

