/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientMessageType;
import com.hazelcast.client.impl.protocol.codec.MemberAttributeChangeCodec;
import com.hazelcast.client.impl.protocol.codec.MemberCodec;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.core.Member;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ClientMembershipListenerCodec {
    public static final ClientMessageType REQUEST_TYPE = ClientMessageType.CLIENT_MEMBERSHIPLISTENER;
    public static final int RESPONSE_TYPE = 104;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(String response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(104);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        String response = null;
        parameters.response = response = clientMessage.getStringUtf8();
        return parameters;
    }

    public static ClientMessage encodeMemberEvent(Member member, int eventType) {
        int dataSize = ClientMessage.HEADER_SIZE;
        dataSize += MemberCodec.calculateDataSize(member);
        ClientMessage clientMessage = ClientMessage.createForEncode(dataSize += 4);
        clientMessage.setMessageType(200);
        clientMessage.addFlag((short)1);
        MemberCodec.encode(member, clientMessage);
        clientMessage.set(eventType);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ClientMessage encodeMemberListEvent(Collection<Member> members) {
        int dataSize = ClientMessage.HEADER_SIZE;
        dataSize += 4;
        for (Member members_item : members) {
            dataSize += MemberCodec.calculateDataSize(members_item);
        }
        ClientMessage clientMessage = ClientMessage.createForEncode(dataSize);
        clientMessage.setMessageType(201);
        clientMessage.addFlag((short)1);
        clientMessage.set(members.size());
        for (Member members_item : members) {
            MemberCodec.encode(members_item, clientMessage);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ClientMessage encodeMemberAttributeChangeEvent(MemberAttributeChange memberAttributeChange) {
        int dataSize = ClientMessage.HEADER_SIZE;
        ClientMessage clientMessage = ClientMessage.createForEncode(dataSize += MemberAttributeChangeCodec.calculateDataSize(memberAttributeChange));
        clientMessage.setMessageType(202);
        clientMessage.addFlag((short)1);
        MemberAttributeChangeCodec.encode(memberAttributeChange, clientMessage);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            if (messageType == 200) {
                Member member = null;
                member = MemberCodec.decode(clientMessage);
                int eventType = clientMessage.getInt();
                this.handle(member, eventType);
                return;
            }
            if (messageType == 201) {
                ArrayList<Member> members = null;
                int members_size = clientMessage.getInt();
                members = new ArrayList<Member>(members_size);
                for (int members_index = 0; members_index < members_size; ++members_index) {
                    Member members_item = MemberCodec.decode(clientMessage);
                    members.add(members_item);
                }
                this.handle(members);
                return;
            }
            if (messageType == 202) {
                MemberAttributeChange memberAttributeChange = null;
                memberAttributeChange = MemberAttributeChangeCodec.decode(clientMessage);
                this.handle(memberAttributeChange);
                return;
            }
            Logger.getLogger(super.getClass()).warning("Unknown message type received on event handler :" + clientMessage.getMessageType());
        }

        public abstract void handle(Member var1, int var2);

        public abstract void handle(Collection<Member> var1);

        public abstract void handle(MemberAttributeChange var1);
    }

    public static class ResponseParameters {
        public String response;

        public static int calculateDataSize(String response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += ParameterUtil.calculateStringDataSize(response);
        }
    }

    public static class RequestParameters {
        public static final ClientMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

