/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.util.CanEstimateSize;

public class LruCache<Key, Value extends CanEstimateSize> {
    private final EvictAction<Value> onEvict;
    private final CreateAction<Key, Value> createAction;
    private final int maxSizeEntries;
    private final long maxSizeBytes;
    private long currentSize;
    private final Map<Key, Value> cache;
    public static final CreateAction NOOP_CREATE_ACTION = new CreateAction(){

        public Object create(Object o) throws SQLException {
            return null;
        }
    };
    public static final EvictAction NOOP_EVICT_ACTION = new EvictAction(){

        public void evict(Object o) throws SQLException {
        }
    };

    private void evictValue(Value value) {
        try {
            this.onEvict.evict(value);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public LruCache(int maxSizeEntries, long maxSizeBytes, boolean accessOrder) {
        this(maxSizeEntries, maxSizeBytes, accessOrder, NOOP_CREATE_ACTION, NOOP_EVICT_ACTION);
    }

    public LruCache(int maxSizeEntries, long maxSizeBytes, boolean accessOrder, CreateAction<Key, Value> createAction, EvictAction<Value> onEvict) {
        this.maxSizeEntries = maxSizeEntries;
        this.maxSizeBytes = maxSizeBytes;
        this.createAction = createAction;
        this.onEvict = onEvict;
        this.cache = new LimitedMap(16, 0.75f, accessOrder);
    }

    public synchronized Value get(Key key) {
        return (Value)((CanEstimateSize)this.cache.get(key));
    }

    public synchronized Value borrow(Key key) throws SQLException {
        CanEstimateSize value = (CanEstimateSize)this.cache.remove(key);
        if (value == null) {
            return (Value)((CanEstimateSize)this.createAction.create(key));
        }
        this.currentSize -= value.getSize();
        return (Value)value;
    }

    public synchronized void put(Key key, Value value) {
        long valueSize = value.getSize();
        if (this.maxSizeBytes == 0L || this.maxSizeEntries == 0 || valueSize * 2L > this.maxSizeBytes) {
            this.evictValue(value);
            return;
        }
        this.currentSize += valueSize;
        CanEstimateSize prev = (CanEstimateSize)this.cache.put(key, value);
        if (prev == null) {
            return;
        }
        this.currentSize -= prev.getSize();
        if (prev != value) {
            this.evictValue(prev);
        }
    }

    private class LimitedMap
    extends LinkedHashMap<Key, Value> {
        LimitedMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, Value> eldest) {
            if (this.size() <= LruCache.this.maxSizeEntries && LruCache.this.currentSize <= LruCache.this.maxSizeBytes) {
                return false;
            }
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                if (this.size() <= LruCache.this.maxSizeEntries && LruCache.this.currentSize <= LruCache.this.maxSizeBytes) {
                    return false;
                }
                Map.Entry entry = it.next();
                LruCache.this.evictValue((CanEstimateSize)entry.getValue());
                long valueSize = ((CanEstimateSize)entry.getValue()).getSize();
                if (valueSize > 0L) {
                    LruCache.this.currentSize -= valueSize;
                }
                it.remove();
            }
            return false;
        }
    }

    public static interface CreateAction<Key, Value> {
        public Value create(Key var1) throws SQLException;
    }

    public static interface EvictAction<Value> {
        public void evict(Value var1) throws SQLException;
    }
}

