/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.components.NextScreenListener;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import com.install4j.runtime.installer.platform.UserInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ProgramGroupScreen
extends InstallerScreen
implements NextScreenListener {
    private ProgramGroupSelector programGroupSelector;
    private JCheckBox chkDisable;
    private JCheckBox chkAllUsers;

    public ProgramGroupScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
        this.checkEnabled();
    }

    public void nextScreen() {
        if (this.btnForward.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.btnForward, 0, null));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.chkDisable) {
            this.checkEnabled();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public String getSelectedProgramGroup() {
        return this.programGroupSelector.getSelectedProgramGroup();
    }

    public boolean isCreateMenu() {
        return !InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isAllowUserDisableStartMenuCreation() || !this.chkDisable.isSelected();
    }

    public boolean isAllUsers() {
        return this.chkAllUsers.isSelected();
    }

    public void activate() {
        super.activate();
        this.programGroupSelector.focusTextField();
    }

    protected boolean checkCompleted() {
        return this.programGroupSelector.checkSelectedProgramGroup() && super.checkCompleted();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(this.messages.getString("SelectStartMenuFolderLabel"), jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.programGroupSelector, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        if (UserInfo.isAdminUser()) {
            gridBagConstraints.insets.bottom = InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isAllowUserDisableStartMenuCreation() ? 0 : 5;
            jPanel.add((Component)this.chkAllUsers, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.insets.bottom = 5;
        if (InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isAllowUserDisableStartMenuCreation()) {
            jPanel.add((Component)this.chkDisable, gridBagConstraints);
        } else {
            jPanel.add((Component)new JPanel(), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
    }

    protected String getTitle() {
        return this.messages.getString("WizardSelectProgramGroup");
    }

    protected String getSubTitle() {
        return this.messages.getString("SelectStartMenuFolderDesc");
    }

    protected void setupControls() {
        super.setupControls();
        this.programGroupSelector = new ProgramGroupSelector(InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().getProgramGroup(), true, this);
        this.chkDisable = new JCheckBox(this.messages.getString("NoProgramGroupCheck2"));
        this.chkAllUsers = new JCheckBox(this.messages.getString("ProgramGroupAllUsers"));
        this.chkAllUsers.setSelected(true);
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.chkDisable.addActionListener(this);
    }

    protected boolean needsSpacer() {
        return false;
    }

    private void checkEnabled() {
        boolean bl = !this.chkDisable.isSelected();
        this.programGroupSelector.setEnabled(bl);
        this.chkAllUsers.setEnabled(bl);
    }
}

