/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import com.lti.utils.OSUtils;
import com.lti.utils.StringUtils;
import java.io.File;

public final class URLUtils {
    public static String createAbsoluteFileUrl(String urlStr) {
        String path = URLUtils.extractValidPathFromFileUrl(urlStr);
        if (path == null) {
            return null;
        }
        return URLUtils.createUrlStr(new File(path));
    }

    public static String createUrlStr(File file) {
        String path = file.getAbsolutePath();
        String prefix = path.startsWith("/") ? "file://" : "file:///";
        if (OSUtils.isWindows()) {
            path = path.replaceAll("\\\\", "/");
        }
        return prefix + StringUtils.replaceSpecialUrlChars(path, true);
    }

    private static boolean exists(String path, boolean checkParentDirOnly) {
        File f = new File(path);
        if (checkParentDirOnly) {
            return f.getParentFile() == null || f.getParentFile().exists();
        }
        return f.exists();
    }

    public static String extractValidNewFilePathFromFileUrl(String url) {
        return URLUtils.extractValidPathFromFileUrl(url, true);
    }

    public static String extractValidPathFromFileUrl(String url) {
        return URLUtils.extractValidPathFromFileUrl(url, false);
    }

    private static String extractValidPathFromFileUrl(String url, boolean checkParentDirOnly) {
        String result;
        if (!url.startsWith("file:")) {
            return null;
        }
        String remainder = url.substring("file:".length());
        if (!(remainder = StringUtils.restoreSpecialURLChars(remainder)).startsWith("/")) {
            return remainder;
        }
        if (remainder.startsWith("//") && URLUtils.exists(result = remainder.substring(2), checkParentDirOnly)) {
            return URLUtils.windowsSafe(result);
        }
        result = remainder;
        while (result.startsWith("//")) {
            result = result.substring(1);
        }
        if (URLUtils.exists(result, checkParentDirOnly)) {
            return URLUtils.windowsSafe(result);
        }
        while (result.startsWith("/")) {
            if (!URLUtils.exists(result = result.substring(1), checkParentDirOnly)) continue;
            return URLUtils.windowsSafe(result);
        }
        return null;
    }

    private static String windowsSafe(String result) {
        if (OSUtils.isWindows() && result.startsWith("/")) {
            return result.substring(1);
        }
        return result;
    }

    private URLUtils() {
    }
}

