/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.RTPPacketSender;
import net.sf.fmj.media.rtp.util.UDPPacket;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;
    private DatagramSocket socket = null;
    private RTPConnector rtpConnector = null;

    public RTPRawSender(int n, String string) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(string);
        this.destport = n;
        this.destAddressList = null;
    }

    public RTPRawSender(int n, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(n, string);
        this.socket = uDPPacketSender.getSocket();
        this.setConsumer(uDPPacketSender);
        this.destAddressList = null;
    }

    public RTPRawSender(RTPPacketSender rTPPacketSender) {
        this.rtpConnector = rTPPacketSender.getConnector();
        this.setConsumer(rTPPacketSender);
    }

    public void assemble(RTPPacket rTPPacket) {
        int n = rTPPacket.calcLength();
        rTPPacket.assemble(n, false);
    }

    public String filtername() {
        return "RTP Raw Packet Sender";
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public int getSendBufSize() {
        try {
            if (this.socket != null) {
                Class<?> clazz = this.socket.getClass();
                Method method = clazz.getMethod("getSendBufferSize", new Class[0]);
                Integer n = (Integer)method.invoke((Object)this.socket, new Object[0]);
                return n;
            }
            if (this.rtpConnector != null) {
                return this.rtpConnector.getSendBufferSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public Packet handlePacket(Packet packet) {
        this.assemble((RTPPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = this.destaddr;
        uDPPacket.remotePort = this.destport;
        return uDPPacket;
    }

    public Packet handlePacket(Packet packet, int n) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        this.assemble((RTPPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = sessionAddress.getDataAddress();
        uDPPacket.remotePort = sessionAddress.getDataPort();
        return uDPPacket;
    }

    public void setDestAddresses(Vector vector) {
        this.destAddressList = vector;
    }

    public void setSendBufSize(int n) {
        try {
            if (this.socket != null) {
                Class<?> clazz = this.socket.getClass();
                Method method = clazz.getMethod("setSendBufferSize", Integer.TYPE);
                method.invoke((Object)this.socket, new Integer(n));
            } else if (this.rtpConnector != null) {
                this.rtpConnector.setSendBufferSize(n);
            }
        }
        catch (Exception exception) {
            Log.comment("Cannot set send buffer size: " + exception);
        }
    }
}

