/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractGainControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.GainMeter;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public class StandardGainMeterControl
extends AbstractGainControl
implements GainChangeListener {
    public StandardGainMeterControl(Skin skin) {
        super(skin);
    }

    public StandardGainMeterControl(Skin skin, Controller controller) {
        super(skin, controller);
    }

    protected Component createControlComponent(Skin skin) {
        return skin.createGainMeterButton();
    }

    protected EventListener createControlListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GainControl gainControl;
                boolean bl = (gainControl = StandardGainMeterControl.this.getGainControl()).getMute();
                gainControl.setMute(!bl);
                StandardGainMeterControl.this.setMute(!bl);
            }
        };
    }

    public void gainChange(GainChangeEvent gainChangeEvent) {
        float f = gainChangeEvent.getSourceGainControl().getLevel();
        SwingUtilities.invokeLater(new SetLevelThread(f));
    }

    protected void setControllerHook(Controller controller) {
        super.setControllerHook(controller);
        if (this.isOperational()) {
            GainControl gainControl = this.getGainControl();
            this.setLevel(gainControl.getLevel());
            this.setMute(gainControl.getMute());
            gainControl.addGainChangeListener(this);
        }
    }

    public void setLevel(float f) {
        ((GainMeter)((Object)this.getControlComponent())).setLevel(f);
    }

    public void setMute(boolean bl) {
        ((GainMeter)((Object)this.getControlComponent())).setMute(bl);
    }

    class SetLevelThread
    implements Runnable {
        private float level;

        public SetLevelThread(float f) {
            this.level = f;
        }

        public void run() {
            StandardGainMeterControl.this.setLevel(this.level);
        }
    }
}

