/*
 * Decompiled with CFR 0.152.
 */
package javax.media.pim;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Renderer;
import javax.media.pim.PlugInInfo;
import net.sf.fmj.registry.Registry;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInManager
extends javax.media.PlugInManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static boolean TRACE = false;
    private static Registry registry = Registry.getInstance();
    private static final HashMap<String, PlugInInfo>[] pluginMaps = new HashMap[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};

    public static synchronized boolean addPlugIn(String string, Format[] formatArray, Format[] formatArray2, int n) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.finer("addPlugIn failed for nonexistant class: " + string);
            return false;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Unable to addPlugIn for " + string + " due to inability to get its class: " + throwable, throwable);
            return false;
        }
        if (PlugInManager.find(string, n) != null) {
            return false;
        }
        PlugInInfo plugInInfo = new PlugInInfo(string, formatArray, formatArray2);
        List<String> list = registry.getPluginList(n);
        HashMap<String, PlugInInfo> hashMap = pluginMaps[n - 1];
        list.add(string);
        hashMap.put(string, plugInInfo);
        registry.setPluginList(n, list);
        return true;
    }

    public static synchronized void commit() throws IOException {
        registry.commit();
    }

    private static synchronized PlugInInfo find(String string, int n) {
        PlugInInfo plugInInfo = pluginMaps[n - 1].get(string);
        return plugInInfo;
    }

    private static final PlugInInfo getPluginInfo(String string) {
        Format[] formatArray;
        Format[] formatArray2;
        Object obj;
        try {
            obj = Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            logger.fine("Problem loading plugin " + string + ": " + throwable);
            return null;
        }
        if (obj instanceof Demultiplexer) {
            Demultiplexer demultiplexer = (Demultiplexer)obj;
            formatArray2 = demultiplexer.getSupportedInputContentDescriptors();
            formatArray = null;
        } else if (obj instanceof Codec) {
            Codec codec = (Codec)obj;
            formatArray2 = codec.getSupportedInputFormats();
            formatArray = codec.getSupportedOutputFormats(null);
        } else if (obj instanceof Multiplexer) {
            Multiplexer multiplexer = (Multiplexer)obj;
            formatArray2 = multiplexer.getSupportedInputFormats();
            formatArray = multiplexer.getSupportedOutputContentDescriptors(null);
        } else if (obj instanceof Renderer) {
            Renderer renderer = (Renderer)obj;
            formatArray2 = renderer.getSupportedInputFormats();
            formatArray = null;
        } else if (obj instanceof Effect) {
            Effect effect = (Effect)obj;
            formatArray2 = effect.getSupportedInputFormats();
            formatArray = effect.getSupportedOutputFormats(null);
        } else {
            logger.warning("Unknown plugin type: " + obj + " for plugin " + string);
            return null;
        }
        return new PlugInInfo(string, formatArray2, formatArray);
    }

    public static synchronized Vector<String> getPlugInList(Format format, Format format2, int n) {
        if (TRACE) {
            logger.info("getting plugin list...");
        }
        if (!PlugInManager.isValid(n)) {
            return new Vector<String>();
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = PlugInManager.getVector(n);
        HashMap<String, PlugInInfo> hashMap = pluginMaps[n - 1];
        for (int i = 0; i < vector2.size(); ++i) {
            int n2;
            boolean bl;
            String string = vector2.get(i);
            PlugInInfo plugInInfo = hashMap.get(string);
            if (plugInInfo == null) continue;
            if (format != null) {
                if (plugInInfo.inputFormats == null) continue;
                bl = false;
                for (n2 = 0; n2 < plugInInfo.inputFormats.length; ++n2) {
                    if (!format.matches(plugInInfo.inputFormats[n2])) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (format2 != null) {
                if (plugInInfo.outputFormats == null) continue;
                bl = false;
                for (n2 = 0; n2 < plugInInfo.outputFormats.length; ++n2) {
                    if (!format2.matches(plugInInfo.outputFormats[n2])) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            vector.add(plugInInfo.className);
        }
        return vector;
    }

    public static synchronized Format[] getSupportedInputFormats(String string, int n) {
        PlugInInfo plugInInfo = PlugInManager.find(string, n);
        if (plugInInfo == null) {
            return null;
        }
        return plugInInfo.inputFormats;
    }

    public static synchronized Format[] getSupportedOutputFormats(String string, int n) {
        PlugInInfo plugInInfo = PlugInManager.find(string, n);
        if (plugInInfo == null) {
            return null;
        }
        return plugInInfo.outputFormats;
    }

    private static Vector<String> getVector(int n) {
        if (!PlugInManager.isValid(n)) {
            return null;
        }
        List<String> list = registry.getPluginList(n);
        Vector<String> vector = new Vector<String>();
        vector.addAll(list);
        return vector;
    }

    private static boolean isValid(int n) {
        return n >= 1 && n <= 5;
    }

    public static synchronized boolean removePlugIn(String string, int n) {
        List<String> list = registry.getPluginList(n);
        HashMap<String, PlugInInfo> hashMap = pluginMaps[n - 1];
        boolean bl = list.remove(string) | hashMap.remove(string) != null;
        registry.setPluginList(n, list);
        return bl;
    }

    public static synchronized void setPlugInList(Vector vector, int n) {
        registry.setPluginList(n, vector);
    }

    private PlugInManager() {
    }

    static {
        for (int i = 0; i < 5; ++i) {
            List<String> list = registry.getPluginList(i + 1);
            HashMap<String, PlugInInfo> hashMap = pluginMaps[i];
            for (String string : list) {
                PlugInInfo plugInInfo = PlugInManager.getPluginInfo(string);
                if (plugInInfo == null) continue;
                hashMap.put(plugInInfo.className, plugInInfo);
            }
        }
    }
}

