/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.FullRoomInfo;

public final class MiniRoomInfo
implements LiveWritable {
    private final int exchange;
    private final String cookie;
    private final int instance;
    private final int totalSize;

    public static MiniRoomInfo readMiniRoomInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 5) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        short s = BinaryTools.getUByte(byteBlock, 2);
        if (byteBlock.getLength() < 5 + s) {
            return null;
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(3, s);
        String string = BinaryTools.getAsciiString(byteBlock2);
        ByteBlock byteBlock3 = byteBlock.subBlock(3 + s);
        int n2 = BinaryTools.getUShort(byteBlock3, 0);
        int n3 = byteBlock3.getOffset() + 2 - byteBlock.getOffset();
        return new MiniRoomInfo(n, string, n2, n3);
    }

    protected MiniRoomInfo(int n, String string, int n2, int n3) {
        DefensiveTools.checkRange(n, "exchange", 0);
        DefensiveTools.checkNull(string, "cookie");
        DefensiveTools.checkRange(n2, "instance", 0);
        DefensiveTools.checkRange(n3, "totalSize", -1);
        this.exchange = n;
        this.cookie = string;
        this.instance = n2;
        this.totalSize = n3;
    }

    public MiniRoomInfo(FullRoomInfo fullRoomInfo) {
        this.exchange = fullRoomInfo.getExchange();
        this.cookie = fullRoomInfo.getCookie();
        this.instance = fullRoomInfo.getInstance();
        this.totalSize = -1;
    }

    public MiniRoomInfo(int n, String string, int n2) {
        this(n, string, n2, -1);
    }

    public final int getExchange() {
        return this.exchange;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final int getInstance() {
        return this.instance;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.exchange);
        byte[] byArray = BinaryTools.getAsciiBytes(this.cookie);
        BinaryTools.writeUByte(outputStream, byArray.length);
        outputStream.write(byArray);
        BinaryTools.writeUShort(outputStream, this.instance);
    }

    public String toString() {
        return "MiniRoomInfo: exchange #" + this.exchange + ", instance #" + this.instance + ", cookie=" + this.cookie;
    }
}

