/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapListenerAdaptors;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.util.Preconditions;

class InternalMapListenerAdapter
implements ListenerAdapter {
    private final ListenerAdapter[] listenerAdapters;

    InternalMapListenerAdapter(MapListener mapListener) {
        Preconditions.isNotNull(mapListener, "mapListener");
        this.listenerAdapters = MapListenerAdaptors.createListenerAdapters(mapListener);
    }

    @Override
    public void onEvent(IMapEvent event) {
        EntryEventType eventType = event.getEventType();
        ListenerAdapter listenerAdapter = this.listenerAdapters[eventType.ordinal()];
        if (listenerAdapter == null) {
            return;
        }
        listenerAdapter.onEvent(event);
    }
}

