/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.exceptions;

import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jivesoftware.openfire.plugin.rest.exceptions.ErrorResponse;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RESTExceptionMapper
implements ExceptionMapper<ServiceException> {
    private static Logger LOG = LoggerFactory.getLogger(RESTExceptionMapper.class);
    @Context
    private HttpHeaders headers;

    public Response toResponse(ServiceException exception) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setResource(exception.getResource());
        errorResponse.setMessage(exception.getMessage());
        errorResponse.setException(exception.getException());
        LOG.error(exception.getException() + ": " + exception.getMessage() + " with resource " + exception.getResource(), (Object)exception.getException());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)exception.getStatus()).entity((Object)errorResponse);
        List accepts = this.headers.getAcceptableMediaTypes();
        if (accepts != null && accepts.size() > 0) {
            MediaType mediaType = (MediaType)accepts.get(0);
            responseBuilder = responseBuilder.type(mediaType);
        } else {
            responseBuilder = responseBuilder.type(this.headers.getMediaType());
        }
        return responseBuilder.build();
    }
}

