/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.plugin.rest.entity.SessionEntities;
import org.jivesoftware.openfire.plugin.rest.entity.SessionEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Presence;
import org.xmpp.packet.StreamError;

public class SessionController {
    public static final SessionController INSTANCE = new SessionController();
    private static Logger LOG = LoggerFactory.getLogger(SessionController.class);

    public static SessionController getInstance() {
        return INSTANCE;
    }

    public SessionEntities getUserSessions(String username) throws ServiceException {
        Collection clientSessions = SessionManager.getInstance().getSessions(username);
        SessionEntities sessionEntities = this.convertToSessionEntities(clientSessions);
        return sessionEntities;
    }

    public SessionEntities getAllSessions() throws ServiceException {
        Collection clientSessions = SessionManager.getInstance().getSessions();
        SessionEntities sessionEntities = this.convertToSessionEntities(clientSessions);
        return sessionEntities;
    }

    public void removeUserSessions(String username) throws ServiceException {
        StreamError error = new StreamError(StreamError.Condition.not_authorized);
        for (ClientSession session : SessionManager.getInstance().getSessions(username)) {
            session.deliverRawText(error.toXML());
            session.close();
        }
    }

    private SessionEntities convertToSessionEntities(Collection<ClientSession> clientSessions) throws ServiceException {
        ArrayList<SessionEntity> sessions = new ArrayList<SessionEntity>();
        SessionEntities sessionEntities = new SessionEntities(sessions);
        for (ClientSession clientSession : clientSessions) {
            SessionEntity session = new SessionEntity();
            session.setSessionId(clientSession.getAddress().toString());
            if (!clientSession.isAnonymousUser()) {
                try {
                    session.setUsername(clientSession.getUsername());
                }
                catch (UserNotFoundException e) {
                    throw new ServiceException("Could not get user", "", "UserNotFoundException", Response.Status.NOT_FOUND, e);
                }
            } else {
                session.setUsername("Anonymous");
            }
            session.setResource(clientSession.getAddress().getResource());
            if (clientSession instanceof LocalClientSession) {
                session.setNode("Local");
            } else {
                session.setNode("Remote");
            }
            String status = "";
            status = clientSession.getStatus() == -1 ? "Closed" : (clientSession.getStatus() == 1 ? "Connected" : (clientSession.getStatus() == 3 ? "Authenticated" : "Unkown"));
            session.setSessionStatus(status);
            if (clientSession.getPresence() != null) {
                session.setPresenceMessage(clientSession.getPresence().getStatus());
                Presence.Show show = clientSession.getPresence().getShow();
                if (show == Presence.Show.away) {
                    session.setPresenceStatus("Away");
                } else if (show == Presence.Show.chat) {
                    session.setPresenceStatus("Available to Chat");
                } else if (show == Presence.Show.dnd) {
                    session.setPresenceStatus("Do Not Disturb");
                } else if (show == Presence.Show.xa) {
                    session.setPresenceStatus("Extended Away");
                } else if (show == null) {
                    session.setPresenceStatus("Online");
                } else {
                    session.setPresenceStatus("Unknown/Not Recognized");
                }
                session.setPriority(clientSession.getPresence().getPriority());
            }
            try {
                session.setHostAddress(clientSession.getHostAddress());
                session.setHostName(clientSession.getHostName());
            }
            catch (UnknownHostException e) {
                LOG.error("UnknownHostException", (Throwable)e);
            }
            session.setCreationDate(clientSession.getCreationDate());
            session.setLastActionDate(clientSession.getLastActiveDate());
            session.setSecure(clientSession.isSecure());
            sessions.add(session);
        }
        return sessionEntities;
    }
}

