/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractCommand;
import f00f.net.irc.martyr.util.FullNick;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class QuitCommand
extends AbstractCommand {
    static Logger log = Logger.getLogger(QuitCommand.class);
    private String reason;
    private FullNick user;

    public QuitCommand() {
        this(null, null);
    }

    public QuitCommand(FullNick user, String reason) {
        this.user = user;
        this.reason = reason;
    }

    public QuitCommand(String reason) {
        this(null, reason);
    }

    public InCommand parse(String prefix, String identifier, String params) {
        return new QuitCommand(new FullNick(prefix), this.getParameter(params, 0));
    }

    public String getIrcIdentifier() {
        return "QUIT";
    }

    public String renderParams() {
        return ":" + this.reason;
    }

    public String getReason() {
        return this.reason;
    }

    public FullNick getUser() {
        return this.user;
    }

    public boolean isOurQuit(ClientState state) {
        return this.user.equals(state.getNick());
    }

    public boolean updateClientState(ClientState state) {
        log.debug((Object)("Nick: " + state.getNick().toString()));
        if (this.isOurQuit(state)) {
            log.debug((Object)("QUIT: We've quit: " + this.reason));
            return true;
        }
        log.debug((Object)("QUIT: " + this.user + " quit: " + this.reason));
        Enumeration channelNames = state.getChannelNames();
        while (channelNames.hasMoreElements()) {
            String chanName = channelNames.nextElement().toString();
            Channel channelObj = state.getChannel(chanName);
            channelObj.removeMember(this.user, (InCommand)this);
        }
        return true;
    }
}

