/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ThreadAuditor {
    private Map threadHandles = new HashMap();
    private long pingIntervalInMillisecs = 0L;

    public long getPingIntervalInMillisecs() {
        return this.pingIntervalInMillisecs;
    }

    public void setPingIntervalInMillisecs(long l) {
        this.pingIntervalInMillisecs = l;
    }

    public boolean isEnabled() {
        return this.pingIntervalInMillisecs > 0L;
    }

    public synchronized ThreadHandle addCurrentThread() {
        ThreadHandle threadHandle = new ThreadHandle(this);
        if (this.isEnabled()) {
            this.threadHandles.put(Thread.currentThread(), threadHandle);
        }
        return threadHandle;
    }

    public synchronized void removeThread(Thread thread) {
        this.threadHandles.remove(thread);
    }

    public synchronized void ping(ThreadHandle threadHandle) {
        threadHandle.setThreadActive(true);
    }

    public synchronized void reset() {
        this.threadHandles.clear();
    }

    public synchronized String auditThreads() {
        String string = null;
        Iterator iterator = this.threadHandles.values().iterator();
        while (iterator.hasNext()) {
            ThreadHandle threadHandle = (ThreadHandle)iterator.next();
            if (!threadHandle.isThreadActive()) {
                Thread thread = threadHandle.getThread();
                if (string == null) {
                    string = "Thread Auditor Report:\n";
                }
                string = string + "   Thread [" + thread.getName() + "] has failed to respond to an audit request.\n";
            }
            threadHandle.setThreadActive(false);
        }
        return string;
    }

    public synchronized String toString() {
        String string = "Thread Auditor - List of monitored threads:\n";
        Iterator iterator = this.threadHandles.values().iterator();
        while (iterator.hasNext()) {
            ThreadHandle threadHandle = (ThreadHandle)iterator.next();
            string = string + "   " + threadHandle.toString() + "\n";
        }
        return string;
    }

    public class ThreadHandle {
        private boolean isThreadActive = false;
        private Thread thread = Thread.currentThread();
        private ThreadAuditor threadAuditor;

        public ThreadHandle(ThreadAuditor threadAuditor2) {
            this.threadAuditor = threadAuditor2;
        }

        public boolean isThreadActive() {
            return this.isThreadActive;
        }

        protected void setThreadActive(boolean bl) {
            this.isThreadActive = bl;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void ping() {
            this.threadAuditor.ping(this);
        }

        public long getPingIntervalInMillisecs() {
            return this.threadAuditor.getPingIntervalInMillisecs();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer().append("Thread Name: ").append(this.thread.getName()).append(", Alive: ").append(this.thread.isAlive());
            return stringBuffer.toString();
        }
    }
}

