/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.query.IndexProvider;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class Indexes {
    private static final Index[] EMPTY_INDEX = new Index[0];
    private final ConcurrentMap<String, Index> mapIndexes = new ConcurrentHashMap<String, Index>(3);
    private final AtomicReference<Index[]> indexes = new AtomicReference<Index[]>(EMPTY_INDEX);
    private final IndexCopyBehavior copyBehavior;
    private volatile boolean hasIndex;
    private final InternalSerializationService serializationService;
    private final IndexProvider indexProvider;
    private final Extractors extractors;
    private final boolean global;

    public Indexes(InternalSerializationService serializationService, IndexProvider indexProvider, Extractors extractors, boolean global, IndexCopyBehavior copyBehavior) {
        this.serializationService = serializationService;
        this.indexProvider = indexProvider;
        this.extractors = extractors;
        this.global = global;
        this.copyBehavior = copyBehavior;
    }

    public synchronized Index destroyIndex(String attribute) {
        return (Index)this.mapIndexes.remove(attribute);
    }

    public synchronized Index addOrGetIndex(String attribute, boolean ordered) {
        Index index = (Index)this.mapIndexes.get(attribute);
        if (index != null) {
            return index;
        }
        index = this.indexProvider.createIndex(attribute, ordered, this.extractors, this.serializationService, this.copyBehavior);
        this.mapIndexes.put(attribute, index);
        Object[] indexObjects = this.mapIndexes.values().toArray();
        Index[] newIndexes = new Index[indexObjects.length];
        for (int i = 0; i < indexObjects.length; ++i) {
            newIndexes[i] = (Index)indexObjects[i];
        }
        this.indexes.set(newIndexes);
        this.hasIndex = true;
        return index;
    }

    public Index[] getIndexes() {
        return this.indexes.get();
    }

    public void clearIndexes() {
        for (Index index : this.getIndexes()) {
            index.destroy();
        }
        this.indexes.set(EMPTY_INDEX);
        this.mapIndexes.clear();
        this.hasIndex = false;
    }

    public void removeEntryIndex(Data key, Object value) throws QueryException {
        Index[] indexes;
        for (Index index : indexes = this.getIndexes()) {
            index.removeEntryIndex(key, value);
        }
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public void saveEntryIndex(QueryableEntry queryableEntry, Object oldValue) throws QueryException {
        Index[] indexes;
        for (Index index : indexes = this.getIndexes()) {
            index.saveEntryIndex(queryableEntry, oldValue);
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Index getIndex(String attribute) {
        return (Index)this.mapIndexes.get(attribute);
    }

    public Set<QueryableEntry> query(Predicate predicate) {
        if (this.hasIndex) {
            IndexAwarePredicate iap;
            QueryContext queryContext = new QueryContext(this);
            if (predicate instanceof IndexAwarePredicate && (iap = (IndexAwarePredicate)predicate).isIndexed(queryContext)) {
                return iap.filter(queryContext);
            }
        }
        return null;
    }
}

