/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.NullQueryCache;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ContextMutexFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheEndToEndProvider<K, V> {
    private final ContextMutexFactory mutexFactory;
    private final ConcurrentMap<String, ConcurrentMap<String, InternalQueryCache<K, V>>> mapNameToQueryCaches;
    private final ConstructorFunction<String, ConcurrentMap<String, InternalQueryCache<K, V>>> ctor = new ConstructorFunction<String, ConcurrentMap<String, InternalQueryCache<K, V>>>(){

        @Override
        public ConcurrentMap<String, InternalQueryCache<K, V>> createNew(String arg) {
            return new ConcurrentHashMap();
        }
    };

    public QueryCacheEndToEndProvider(ContextMutexFactory mutexFactory) {
        this.mutexFactory = mutexFactory;
        this.mapNameToQueryCaches = new ConcurrentHashMap<String, ConcurrentMap<String, InternalQueryCache<K, V>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalQueryCache<K, V> getOrCreateQueryCache(String mapName, String cacheId, ConstructorFunction<String, InternalQueryCache<K, V>> constructor) {
        ContextMutexFactory.Mutex mutex = this.mutexFactory.mutexFor(mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                ConcurrentMap<String, InternalQueryCache<String, InternalQueryCache<K, V>>> cacheIdToQueryCache = ConcurrencyUtil.getOrPutIfAbsent(this.mapNameToQueryCaches, mapName, this.ctor);
                InternalQueryCache<K, V> queryCache = (InternalQueryCache<K, V>)cacheIdToQueryCache.get(cacheId);
                if (queryCache == null) {
                    queryCache = constructor.createNew(cacheId);
                    if (queryCache == NullQueryCache.NULL_QUERY_CACHE) {
                        queryCache = null;
                    } else {
                        cacheIdToQueryCache.put(cacheId, queryCache);
                    }
                }
                InternalQueryCache<K, V> internalQueryCache = queryCache;
                return internalQueryCache;
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSingleQueryCache(String mapName, String cacheId) {
        ContextMutexFactory.Mutex mutex = this.mutexFactory.mutexFor(mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                Map cacheIdToQueryCache = (Map)this.mapNameToQueryCaches.get(mapName);
                if (cacheIdToQueryCache != null) {
                    cacheIdToQueryCache.remove(cacheId);
                }
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllQueryCaches(String mapName) {
        ContextMutexFactory.Mutex mutex = this.mutexFactory.mutexFor(mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                Map cacheIdToQueryCache = (Map)this.mapNameToQueryCaches.remove(mapName);
                if (cacheIdToQueryCache != null) {
                    for (InternalQueryCache queryCache : cacheIdToQueryCache.values()) {
                        queryCache.destroy();
                    }
                }
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    public int getQueryCacheCount(String mapName) {
        Map cacheIdToQueryCache = (Map)this.mapNameToQueryCaches.get(mapName);
        if (cacheIdToQueryCache == null) {
            return 0;
        }
        return cacheIdToQueryCache.size();
    }
}

