/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.Position;

abstract class Container {
    private static Map<Type, Type[]> typecache = new HashMap<Type, Type[]>();
    private Object[] parameters = null;

    static void putTypeCache(Type type, Type[] typeArray) {
        typecache.put(type, typeArray);
    }

    static Type[] getTypeCache(Type type) {
        return typecache.get(type);
    }

    private void setup() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        Object[] objectArray = new Object[fieldArray.length];
        int n = 0;
        for (Field field : fieldArray) {
            Position position = field.getAnnotation(Position.class);
            if (null == position) {
                ++n;
                continue;
            }
            try {
                objectArray[position.value()] = field.get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.parameters = new Object[objectArray.length - n];
        System.arraycopy(objectArray, 0, this.parameters, 0, this.parameters.length);
    }

    public final Object[] getParameters() {
        if (null != this.parameters) {
            return this.parameters;
        }
        this.setup();
        return this.parameters;
    }

    public final String toString() {
        String string = this.getClass().getName() + "<";
        if (null == this.parameters) {
            this.setup();
        }
        if (0 == this.parameters.length) {
            return string + ">";
        }
        for (Object object : this.parameters) {
            string = string + object + ", ";
        }
        return string.replaceAll(", $", ">");
    }

    public final boolean equals(Object object) {
        if (object instanceof Container) {
            Container container = (Container)object;
            if (this.getClass().equals(container.getClass())) {
                return Arrays.equals(this.getParameters(), container.getParameters());
            }
            return false;
        }
        return false;
    }
}

